/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.frameworkadapter.util;

import java.lang.reflect.Method;
import org.codehaus.groovy.frameworkadapter.util.SpecifiedVersion;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.prefs.BackingStoreException;

public class CompilerChooser {
    private static CompilerChooser INSTANCE;
    private static final String GROOVY_COMPILER_LEVEL = "groovy.compiler.level";
    private static final String DASH_GROOVY_COMPILER_LEVEL = "-groovy.compiler.level";
    private static final String ECLIPSE_COMMANDS = "eclipse.commands";
    private static final String GROOVY_PLUGIN_ID = "org.codehaus.groovy";
    private Version[] allVersions = new Version[0];
    private SpecifiedVersion[] allSpecifiedVersions = new SpecifiedVersion[0];
    private int activeIndex = -1;
    private boolean initialized;

    CompilerChooser() {
        INSTANCE = this;
    }

    public static CompilerChooser getInstance() {
        return INSTANCE;
    }

    void initialize(BundleContext context) throws BundleException {
        if (!this.initialized) {
            this.initialized = true;
            this.doInitialize(context);
        }
    }

    public boolean isInitiailzed() {
        return this.initialized;
    }

    private void doInitialize(BundleContext context) throws BundleException {
        block11: {
            Bundle[] bundles;
            block12: {
                boolean found;
                block13: {
                    Bundle bundle;
                    SpecifiedVersion specifiedVersion = this.findSysPropVersion();
                    if (specifiedVersion == SpecifiedVersion.UNSPECIFIED) {
                        specifiedVersion = this.getVersionFromPrefenences(context);
                    }
                    System.out.println("Starting Groovy-Eclipse compiler resolver.  Specified compiler level: " + specifiedVersion.toReadableVersionString());
                    bundles = Platform.getBundles((String)GROOVY_PLUGIN_ID, null);
                    this.dump(bundles);
                    if (bundles == null || bundles.length == 0) {
                        System.out.println("No Groovy bundles found...this will cause some problems.");
                        bundles = new Bundle[]{};
                    }
                    this.allVersions = new Version[bundles.length];
                    this.allSpecifiedVersions = new SpecifiedVersion[bundles.length];
                    if (specifiedVersion == SpecifiedVersion.UNSPECIFIED) break block12;
                    found = false;
                    int i = 0;
                    while (i < bundles.length) {
                        bundle = bundles[i];
                        this.allVersions[i] = bundle.getVersion();
                        this.allSpecifiedVersions[i] = SpecifiedVersion.findVersion(bundle.getVersion());
                        if (this.allSpecifiedVersions[i] == specifiedVersion && !found) {
                            this.activeIndex = i;
                            found = true;
                        }
                        ++i;
                    }
                    if (!found) break block13;
                    i = 0;
                    while (i < bundles.length) {
                        bundle = bundles[i];
                        if (i != this.activeIndex) {
                            System.out.println("Avoided bundle version = " + bundle.getVersion());
                            bundle.uninstall();
                        } else {
                            System.out.println("Blessed bundle version = " + bundle.getVersion());
                        }
                        ++i;
                    }
                    PackageAdmin pkgAdmin = (PackageAdmin)context.getService(context.getServiceReference(PackageAdmin.class));
                    try {
                        Method method = pkgAdmin.getClass().getMethod("refreshPackages", Bundle[].class, Boolean.TYPE, FrameworkListener[].class);
                        if (method == null) {
                            pkgAdmin.refreshPackages(bundles);
                            break block11;
                        }
                        method.setAccessible(true);
                        method.invoke((Object)pkgAdmin, bundles, true, null);
                    }
                    catch (Exception exception) {
                        pkgAdmin.refreshPackages(bundles);
                    }
                    break block11;
                }
                if (found) break block11;
                System.out.println("Specified version not found, using " + this.allVersions[0] + " instead.");
                break block11;
            }
            int i = 0;
            while (i < bundles.length) {
                Bundle bundle = bundles[i];
                this.allVersions[i] = bundle.getVersion();
                this.allSpecifiedVersions[i] = SpecifiedVersion.findVersion(bundle.getVersion());
                ++i;
            }
        }
    }

    private void dump(Bundle[] bundles) {
        int i = 0;
        while (i < bundles.length) {
            Bundle b = bundles[i];
            System.out.println(String.valueOf(b.getBundleId()) + " " + b.getVersion() + " = " + CompilerChooser.stateString(b.getState()));
            ++i;
        }
    }

    private static String stateString(int state) {
        switch (state) {
            case 32: {
                return "ACTIVE";
            }
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
        }
        return "UNKOWN(" + state + ")";
    }

    private SpecifiedVersion findSysPropVersion() {
        SpecifiedVersion version = SpecifiedVersion.findVersionFromString(System.getProperty(GROOVY_COMPILER_LEVEL));
        if (version == SpecifiedVersion.UNSPECIFIED) {
            version = this.internalFindCommandLineVersion(System.getProperty(ECLIPSE_COMMANDS));
        }
        return version;
    }

    private SpecifiedVersion internalFindCommandLineVersion(String property) {
        if (property == null) {
            return SpecifiedVersion.UNSPECIFIED;
        }
        String[] split = property.split("\\\n");
        String versionText = null;
        int i = 0;
        while (i < split.length) {
            if (DASH_GROOVY_COMPILER_LEVEL.equals(split[i]) && i < split.length - 1) {
                versionText = split[i + 1];
                break;
            }
            ++i;
        }
        return SpecifiedVersion.findVersionFromString(versionText);
    }

    private SpecifiedVersion getVersionFromPrefenences(BundleContext context) {
        IEclipsePreferences prefNode = InstanceScope.INSTANCE.getNode("org.codehaus.groovy.eclipse.compilerResolver");
        return SpecifiedVersion.findVersionFromString(prefNode.get(GROOVY_COMPILER_LEVEL, null));
    }

    public void storeVersion(SpecifiedVersion version) throws BackingStoreException {
        IEclipsePreferences prefNode = InstanceScope.INSTANCE.getNode("org.codehaus.groovy.eclipse.compilerResolver");
        prefNode.put(GROOVY_COMPILER_LEVEL, version.versionName);
        prefNode.flush();
    }

    public SpecifiedVersion getActiveSpecifiedVersion() {
        if (this.activeIndex == -1) {
            return SpecifiedVersion.findVersion(this.getActiveVersion());
        }
        return this.allSpecifiedVersions[this.activeIndex];
    }

    public Version getActiveVersion() {
        if (this.activeIndex == -1) {
            Bundle bundle = this.getActiveBundle();
            return bundle == null ? null : bundle.getVersion();
        }
        return this.allVersions[this.activeIndex];
    }

    public Bundle getActiveBundle() {
        if (this.activeIndex == -1) {
            Bundle[] bundleArray = Platform.getBundles((String)GROOVY_PLUGIN_ID, null);
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if (bundle.getState() == 32) {
                    return bundle;
                }
                ++n2;
            }
            return Platform.getBundle((String)GROOVY_PLUGIN_ID);
        }
        Bundle[] bundles = Platform.getBundles((String)GROOVY_PLUGIN_ID, (String)this.allVersions[this.activeIndex].toString());
        if (bundles != null && bundles.length > 0) {
            return bundles[0];
        }
        return null;
    }

    public SpecifiedVersion[] getAllSpecifiedVersions() {
        return this.allSpecifiedVersions;
    }

    public Version getAssociatedVersion(SpecifiedVersion specifiedVersion) {
        int i = 0;
        while (i < this.allSpecifiedVersions.length) {
            if (this.allSpecifiedVersions[i] == specifiedVersion) {
                return this.allVersions[i];
            }
            ++i;
        }
        return null;
    }
}

