/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.export.handlers;

import com.kms.katalon.composer.components.impl.thread.ImportExportProgressThread;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.ExportTestCaseController;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.IImportExportController;
import com.kms.katalon.controller.ProjectController;
import java.io.File;
import java.util.List;
import java.util.UUID;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportTestCaseHandler {
    private static final int EXPORT_TEST_CASE_EXTRA_PROGRESS = 3;
    private static final int EXPORT_TEST_CASE_NORMAL_PROGRESS = 8;

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(Shell shell) {
        try {
            if (ProjectController.getInstance().getCurrentProject() != null) {
                List testCases;
                File exportDirectory;
                DirectoryDialog directoryDialog = new DirectoryDialog(shell);
                directoryDialog.open();
                if (directoryDialog.getFilterPath() != null && (exportDirectory = new File(directoryDialog.getFilterPath())) != null && exportDirectory.exists() && exportDirectory.isDirectory() && (testCases = FolderController.getInstance().getTestCaseChildren(FolderController.getInstance().getTestCaseRoot(ProjectController.getInstance().getCurrentProject()))) != null && testCases.size() > 0) {
                    int exportTestCaseMaxProgress = testCases.size() * 8 + 3;
                    ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
                    progressDialog.run(true, true, (IRunnableWithProgress)new ImportExportProgressThread(exportTestCaseMaxProgress, (IImportExportController)new ExportTestCaseController(UUID.randomUUID().toString(), ProjectController.getInstance().getCurrentProject(), exportDirectory.getAbsolutePath(), testCases)));
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

