/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.export.handlers;

import com.kms.katalon.composer.components.impl.thread.ImportExportProgressThread;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.ExportProjectController;
import com.kms.katalon.controller.IImportExportController;
import com.kms.katalon.controller.ProjectController;
import java.io.File;
import java.util.UUID;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportProjectHandler {
    private static final int EXPORT_PROJECT_MAX_PROGRESS = 4;

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(Shell shell) {
        try {
            if (ProjectController.getInstance().getCurrentProject() != null) {
                File exportDirectory;
                DirectoryDialog directoryDialog = new DirectoryDialog(shell);
                directoryDialog.open();
                if (directoryDialog.getFilterPath() != null && (exportDirectory = new File(directoryDialog.getFilterPath())) != null && exportDirectory.exists() && exportDirectory.isDirectory()) {
                    ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
                    progressDialog.run(true, true, (IRunnableWithProgress)new ImportExportProgressThread(4, (IImportExportController)new ExportProjectController(UUID.randomUUID().toString(), ProjectController.getInstance().getCurrentProject(), exportDirectory.getAbsolutePath())));
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

