/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.jira.toolbar.dialog;

import com.kms.katalon.composer.components.impl.providers.TypeCheckedStyleCellLabelProvider;
import com.kms.katalon.composer.integration.jira.constant.ComposerJiraIntegrationMessageConstant;
import com.kms.katalon.composer.integration.jira.constant.ImageConstants;
import com.kms.katalon.integration.jira.entity.JiraIssue;
import java.util.Collections;
import java.util.Map;
import org.eclipse.swt.graphics.Image;

public class JiraImportedColumnLabelProvider
extends TypeCheckedStyleCellLabelProvider<JiraIssue> {
    private Map<Long, JiraIssue> existedIssues = Collections.emptyMap();

    public JiraImportedColumnLabelProvider(int columnIndex) {
        super(columnIndex);
    }

    protected Class<JiraIssue> getElementType() {
        return JiraIssue.class;
    }

    protected Image getImage(JiraIssue issue) {
        return this.isIssueImported(issue) ? ImageConstants.IMG_16_WARNING : null;
    }

    protected String getText(JiraIssue issue) {
        return "";
    }

    protected String getElementToolTipText(JiraIssue issue) {
        return this.isIssueImported(issue) ? ComposerJiraIntegrationMessageConstant.CLMN_STATUS_IMPORTED : null;
    }

    private boolean isIssueImported(JiraIssue issue) {
        return this.existedIssues.containsKey(issue.getId());
    }

    public void setExistedIssues(Map<Long, JiraIssue> existedIssues) {
        this.existedIssues = existedIssues;
    }
}

