/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.jira.toolbar.dialog;

import com.kms.katalon.composer.components.impl.control.TreeEntitySelectionComposite;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.explorer.providers.EntityLabelProvider;
import com.kms.katalon.composer.explorer.providers.EntityProvider;
import com.kms.katalon.composer.explorer.providers.FolderEntityTreeViewerFilter;
import com.kms.katalon.composer.integration.jira.constant.ComposerJiraIntegrationMessageConstant;
import com.kms.katalon.composer.integration.jira.constant.StringConstants;
import com.kms.katalon.composer.integration.jira.report.provider.JiraIssueIDLabelProvider;
import com.kms.katalon.composer.integration.jira.toolbar.dialog.JiraImportedColumnLabelProvider;
import com.kms.katalon.composer.integration.jira.toolbar.dialog.JiraImportedIssueLabelProvider;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.integration.jira.JiraObjectToEntityConverter;
import com.kms.katalon.integration.jira.entity.JiraIssue;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class IssueSelectionDialog
extends AbstractDialog {
    public static final int CLMN_IMPORTED_IDX = 0;
    public static final int CLMN_STATUS_IDX = 3;
    public static final int CLMN_SUMMARY_IDX = 2;
    public static final int CLMN_ISSUE_IDX = 1;
    private List<JiraIssue> issues;
    private TableViewer issueViewer;
    private TreeEntitySelectionComposite folderTreeComposite;
    private FolderTreeEntity selectedFolder;
    private JiraImportedColumnLabelProvider importedIssueProvider;
    private Map<Long, JiraIssue> existedIssues;

    public IssueSelectionDialog(Shell parentShell, List<JiraIssue> issues) {
        super(parentShell);
        this.issues = issues;
    }

    protected void registerControlModifyListeners() {
        final TreeViewer treeViewer = this.folderTreeComposite.getTreeViewer();
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IssueSelectionDialog.this.selectedFolderChanged();
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object firstElement;
                treeViewer.setExpandedState(firstElement, !treeViewer.getExpandedState(firstElement = treeViewer.getStructuredSelection().getFirstElement()));
            }
        });
    }

    private void refreshIssueTable() {
        Job job = new Job(ComposerJiraIntegrationMessageConstant.DIA_JOB_REFRESHING){

            protected IStatus run(IProgressMonitor monitor) {
                UISynchronizeService.syncExec(() -> IssueSelectionDialog.this.getButton(0).setEnabled(false));
                IssueSelectionDialog.this.existedIssues = IssueSelectionDialog.this.getExistedJiraIssues();
                IssueSelectionDialog.this.importedIssueProvider.setExistedIssues(IssueSelectionDialog.this.existedIssues);
                UISynchronizeService.syncExec(() -> {
                    IssueSelectionDialog.this.getButton(0).setEnabled(!IssueSelectionDialog.this.getSelectedIssues().isEmpty());
                    IssueSelectionDialog.this.issueViewer.refresh();
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void selectedFolderChanged() {
        this.selectedFolder = (FolderTreeEntity)this.folderTreeComposite.getTreeViewer().getStructuredSelection().getFirstElement();
        this.refreshIssueTable();
    }

    protected void setInput() {
        try {
            FolderEntity testCaseRoot = FolderController.getInstance().getTestCaseRoot(ProjectController.getInstance().getCurrentProject());
            this.selectedFolder = TreeEntityUtil.createSelectedTreeEntityHierachy((FolderEntity)testCaseRoot, (FolderEntity)testCaseRoot);
            this.folderTreeComposite.setInput(new Object[]{this.selectedFolder});
            this.folderTreeComposite.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)this.selectedFolder));
            this.selectedFolderChanged();
            this.issueViewer.setInput(this.issues);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected Control createDialogContainer(Composite parent) {
        SashForm container = new SashForm(parent, 0);
        this.createTestCaseFolderSelectionComposite((Composite)container);
        this.createIssueTableViewer((Composite)container);
        container.setWeights(new int[]{3, 7});
        return container;
    }

    private void createTestCaseFolderSelectionComposite(Composite container) {
        Composite folderSelectionComposite = new Composite(container, 0);
        GridLayout leftCompositeLayout = new GridLayout(1, false);
        leftCompositeLayout.marginHeight = 0;
        folderSelectionComposite.setLayout((Layout)leftCompositeLayout);
        Label lblFolderSelection = new Label(folderSelectionComposite, 0);
        lblFolderSelection.setLayoutData((Object)new GridData(4, 128, true, false));
        lblFolderSelection.setText(ComposerJiraIntegrationMessageConstant.DIA_LBL_CHOOSE_DESTINATION);
        EntityProvider contentProvider = new EntityProvider();
        this.folderTreeComposite = new TreeEntitySelectionComposite(folderSelectionComposite, 2048, (ITreeContentProvider)contentProvider, (AbstractEntityViewerFilter)new FolderEntityTreeViewerFilter(contentProvider), (IEntityLabelProvider)new EntityLabelProvider());
        this.folderTreeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout treeLayout = new GridLayout(1, false);
        treeLayout.marginWidth = 0;
        treeLayout.marginHeight = 0;
        this.folderTreeComposite.setLayout((Layout)treeLayout);
        this.folderTreeComposite.getTreeViewer().setAutoExpandLevel(-1);
    }

    private void createIssueTableViewer(Composite container) {
        this.issueViewer = new TableViewer(container, 67584);
        Table table = this.issueViewer.getTable();
        table.setHeaderVisible(true);
        TableViewerColumn tableViewerColumnImported = new TableViewerColumn(this.issueViewer, 0);
        TableColumn tblclmnImported = tableViewerColumnImported.getColumn();
        tblclmnImported.setWidth(30);
        this.importedIssueProvider = new JiraImportedColumnLabelProvider(0);
        tableViewerColumnImported.setLabelProvider((CellLabelProvider)this.importedIssueProvider);
        TableViewerColumn tableViewerColumnId = new TableViewerColumn(this.issueViewer, 0);
        TableColumn tblclmnId = tableViewerColumnId.getColumn();
        tblclmnId.setWidth(80);
        tblclmnId.setText(ComposerJiraIntegrationMessageConstant.CM_ISSUE);
        tableViewerColumnId.setLabelProvider((CellLabelProvider)new JiraIssueIDLabelProvider(1));
        TableViewerColumn tableViewerColumnSummary = new TableViewerColumn(this.issueViewer, 0);
        TableColumn tblclmnSummary = tableViewerColumnSummary.getColumn();
        tblclmnSummary.setWidth(250);
        tblclmnSummary.setText(ComposerJiraIntegrationMessageConstant.DIA_LBL_SUMMARY);
        tableViewerColumnSummary.setLabelProvider((CellLabelProvider)new JiraImportedIssueLabelProvider(2));
        TableViewerColumn tableViewerColumnIssueType = new TableViewerColumn(this.issueViewer, 0);
        TableColumn tblclmnType = tableViewerColumnIssueType.getColumn();
        tblclmnType.setWidth(150);
        tblclmnType.setText(StringConstants.STATUS);
        tableViewerColumnIssueType.setLabelProvider((CellLabelProvider)new JiraImportedIssueLabelProvider(3));
        this.issueViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        table.setToolTipText("");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.issueViewer, (int)2);
    }

    public List<JiraIssue> getSelectedIssues() {
        return this.issues.parallelStream().filter(issue -> !this.existedIssues.containsKey(issue.getId())).collect(Collectors.toList());
    }

    public FolderTreeEntity getSelectedFolder() {
        return this.selectedFolder;
    }

    public Map<Long, JiraIssue> getExistedJiraIssues() {
        try {
            FolderEntity folder = this.selectedFolder.getObject();
            HashMap<Long, JiraIssue> existedIssues = new HashMap<Long, JiraIssue>();
            List testCaseChildren = FolderController.getInstance().getTestCaseChildren(folder);
            testCaseChildren.forEach(child -> {
                JiraIssue jiraIssue = JiraObjectToEntityConverter.getJiraIssue((TestCaseEntity)child);
                if (jiraIssue != null) {
                    existedIssues.put(jiraIssue.getId(), jiraIssue);
                }
            });
            return existedIssues;
        }
        catch (Exception exception) {
            return Collections.emptyMap();
        }
    }

    protected Point getInitialSize() {
        return new Point(850, 400);
    }

    public String getDialogTitle() {
        return ComposerJiraIntegrationMessageConstant.DIA_TITLE_JIRA_ISSUES;
    }
}

