/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.jira.toolbar.dialog;

import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.integration.jira.JiraUIComponent;
import com.kms.katalon.composer.integration.jira.constant.ComposerJiraIntegrationMessageConstant;
import com.kms.katalon.composer.integration.jira.preference.JiraPreferenceInitializer;
import com.kms.katalon.integration.jira.JiraIntegrationAuthenticationHandler;
import com.kms.katalon.integration.jira.JiraIntegrationException;
import com.kms.katalon.integration.jira.entity.JiraFilter;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportJiraJQLDialog
extends AbstractDialog
implements JiraUIComponent {
    private Text text;
    private JiraFilter filter;

    public ImportJiraJQLDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
        this.text.setText(JiraPreferenceInitializer.getLastEditedJQL(this.getCurrentProject()));
        this.text.setFocus();
        this.text.selectAll();
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.horizontalSpacing = 15;
        container.setLayout((Layout)containerLayout);
        Label lblJiraJql = new Label(container, 0);
        lblJiraJql.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        lblJiraJql.setText(ComposerJiraIntegrationMessageConstant.DIA_LBL_JIRA_JQL);
        this.text = new Text(container, 2114);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        return container;
    }

    public String getDialogTitle() {
        return ComposerJiraIntegrationMessageConstant.DIA_TITLE_IMPORT_FROM_JQL;
    }

    protected void okPressed() {
        Job job = new Job(ComposerJiraIntegrationMessageConstant.DIA_JOB_FETCH_ISSUES){
            private String jql;
            {
                this.jql = "";
            }

            protected IStatus run(IProgressMonitor monitor) {
                UISynchronizeService.syncExec(() -> {
                    this.jql = ImportJiraJQLDialog.this.text.getText();
                    ImportJiraJQLDialog.this.getButton(0).setEnabled(false);
                });
                try {
                    ImportJiraJQLDialog.this.filter = new JiraIntegrationAuthenticationHandler().getJiraFilterByJql(ImportJiraJQLDialog.this.getCredential(), this.jql);
                    UISynchronizeService.syncExec(() -> {
                        ImportJiraJQLDialog.this.updateJQLForNextUsage(this.jql);
                        ImportJiraJQLDialog.super.okPressed();
                    });
                    return Status.OK_STATUS;
                }
                catch (JiraIntegrationException | IOException e) {
                    UISynchronizeService.syncExec(() -> this.lambda$2((Exception)e));
                    LoggerSingleton.logError((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
            }

            private /* synthetic */ void lambda$2(Exception exception) {
                MessageDialog.openWarning((Shell)ImportJiraJQLDialog.this.getShell(), (String)StringConstants.WARN, (String)exception.getMessage());
                ImportJiraJQLDialog.this.getButton(0).setEnabled(true);
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void updateJQLForNextUsage(String jql) {
        try {
            JiraPreferenceInitializer.saveLastEditedJQL(jql, this.getCurrentProject());
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public JiraFilter getFilter() {
        return this.filter;
    }

    protected Point getInitialSize() {
        return new Point(500, 250);
    }

    protected boolean hasDocumentation() {
        return true;
    }

    protected String getDocumentationUrl() {
        return ComposerJiraIntegrationMessageConstant.DIA_DOCUMENT_URL_IMPORT_TEST_CASE_FROM_JIRA;
    }
}

