/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.jira.testcase;

import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.integration.jira.JiraUIComponent;
import com.kms.katalon.composer.integration.jira.constant.ComposerJiraIntegrationMessageConstant;
import com.kms.katalon.composer.integration.jira.constant.StringConstants;
import com.kms.katalon.composer.testcase.parts.integration.AbstractTestCaseIntegrationView;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.integration.jira.JiraObjectToEntityConverter;
import com.kms.katalon.integration.jira.entity.ImprovedIssue;
import com.kms.katalon.integration.jira.entity.JiraIssue;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class JiraTestCaseIntegrationView
extends AbstractTestCaseIntegrationView
implements JiraUIComponent {
    private Composite container;
    private Link lblDisplayKey;
    private Label lblDisplaySummary;
    private Label lblDisplayStatus;
    private Label lblDisplayDiscription;
    private JiraIssue jiraIssue;

    public JiraTestCaseIntegrationView(TestCaseEntity testCaseEntity, MPart mpart) {
        super(testCaseEntity, mpart);
        this.jiraIssue = JiraObjectToEntityConverter.getJiraIssue((TestCaseEntity)testCaseEntity);
    }

    public Composite createContainer(Composite parent) {
        this.container = new Composite(parent, 2048);
        this.container.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.container.setBackgroundMode(2);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 15;
        this.container.setLayout((Layout)gridLayout);
        Label lblKey = new Label(this.container, 0);
        lblKey.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblKey.setText(ComposerJiraIntegrationMessageConstant.VIEW_LBL_KEY);
        this.lblDisplayKey = new Link(this.container, 0);
        this.lblDisplayKey.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.lblDisplayKey.setToolTipText(ComposerJiraIntegrationMessageConstant.VIEW_TOOLTIP_VIEW_ISSUE_ON_JIRA);
        Label lblSummary = new Label(this.container, 0);
        lblSummary.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblSummary.setText(StringConstants.SUMMARY);
        this.lblDisplaySummary = new Label(this.container, 64);
        this.lblDisplaySummary.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblStatus = new Label(this.container, 0);
        lblStatus.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblStatus.setText(StringConstants.STATUS);
        this.lblDisplayStatus = new Label(this.container, 0);
        this.lblDisplayStatus.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblDescription = new Label(this.container, 0);
        lblDescription.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblDescription.setText(StringConstants.DESCRIPTION);
        this.lblDisplayDiscription = new Label(this.container, 64);
        this.lblDisplayDiscription.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.setInput();
        this.registerControlListeners();
        return this.container;
    }

    private void registerControlListeners() {
        this.lblDisplayKey.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                try {
                    Program.launch((String)JiraTestCaseIntegrationView.this.getHTMLLink(JiraTestCaseIntegrationView.this.jiraIssue).toURL().toString());
                }
                catch (IOException | URISyntaxException | GeneralSecurityException ex) {
                    LoggerSingleton.logError((Throwable)ex);
                }
            }
        });
    }

    private void setInput() {
        if (this.jiraIssue == null) {
            ControlUtils.recursiveSetEnabled((Control)this.container, (boolean)false);
            return;
        }
        this.lblDisplayKey.setText("<a>" + this.jiraIssue.getKey() + "</a>");
        ImprovedIssue fields = this.jiraIssue.getFields();
        this.lblDisplaySummary.setText(StringUtils.defaultString((String)fields.getSummary()));
        this.lblDisplayStatus.setText(StringUtils.defaultString((String)fields.getStatus().getName()));
        this.lblDisplayDiscription.setText(StringUtils.defaultString((String)fields.getDescription()));
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.TEST_CASE_INTEGRATION_JIRA;
    }
}

