/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.jira.report.provider;

import com.kms.katalon.composer.components.impl.providers.CellLayoutInfo;
import com.kms.katalon.composer.components.impl.providers.DefaultCellLayoutInfo;
import com.kms.katalon.composer.components.impl.providers.HoveredImageColumnLabelProvider;
import com.kms.katalon.composer.integration.jira.JiraUIComponent;
import com.kms.katalon.composer.integration.jira.constant.ComposerJiraIntegrationMessageConstant;
import com.kms.katalon.composer.integration.jira.constant.ImageConstants;
import com.kms.katalon.composer.integration.jira.constant.StringConstants;
import com.kms.katalon.composer.integration.jira.report.JiraCreateIssueHandler;
import com.kms.katalon.composer.integration.jira.report.JiraReportTestLogColumn;
import com.kms.katalon.composer.integration.jira.report.dialog.progress.JiraIssueProgressResult;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStepLogRecord;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.integration.jira.JiraIntegrationException;
import com.kms.katalon.integration.jira.entity.JiraIssueCollection;
import java.util.Arrays;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class JiraTestLogIssueLabelProvider
extends HoveredImageColumnLabelProvider<ILogRecord>
implements JiraUIComponent {
    private JiraReportTestLogColumn view;

    public JiraTestLogIssueLabelProvider(int columnIndex, JiraReportTestLogColumn view) {
        super(columnIndex);
        this.view = view;
    }

    public CellLayoutInfo getCellLayoutInfo() {
        return new DefaultCellLayoutInfo(){

            public int getLeftMargin() {
                return 5;
            }
        };
    }

    protected void handleMouseDown(MouseEvent e, final ViewerCell cell) {
        final Shell activeShell = e.display.getActiveShell();
        Menu jiraIssueMenu = new Menu((Control)activeShell);
        MenuItem newIssueItem = new MenuItem(jiraIssueMenu, 8);
        newIssueItem.setText(ComposerJiraIntegrationMessageConstant.DIA_ITEM_CREATE_NEW_JIRA_ISSUE);
        newIssueItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraIssueProgressResult result;
                JiraCreateIssueHandler handler = JiraTestLogIssueLabelProvider.this.newCreateIssueHandler(activeShell);
                if (handler.checkResult(result = handler.openNewIssueDialog(JiraTestLogIssueLabelProvider.this.getIndexOfStepLogRecord(cell)))) {
                    JiraTestLogIssueLabelProvider.this.addJiraIssueAndUpdateReport(activeShell, result);
                }
            }
        });
        MenuItem newIssueAsSubTaskItem = new MenuItem(jiraIssueMenu, 8);
        newIssueAsSubTaskItem.setText(ComposerJiraIntegrationMessageConstant.DIA_ITEM_CREATE_AS_SUB_TASK);
        newIssueAsSubTaskItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraIssueProgressResult result;
                JiraCreateIssueHandler handler = JiraTestLogIssueLabelProvider.this.newCreateIssueHandler(activeShell);
                if (handler.checkResult(result = handler.openCreateAsSubTaskDialog(JiraTestLogIssueLabelProvider.this.getIndexOfStepLogRecord(cell)))) {
                    JiraTestLogIssueLabelProvider.this.addJiraIssueAndUpdateReport(activeShell, result);
                }
            }
        });
        MenuItem linkIssueItem = new MenuItem(jiraIssueMenu, 8);
        linkIssueItem.setText(ComposerJiraIntegrationMessageConstant.DIA_ITEM_LINK_TO_JIRA_ISSUE);
        linkIssueItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraIssueProgressResult result;
                JiraCreateIssueHandler handler = JiraTestLogIssueLabelProvider.this.newCreateIssueHandler(activeShell);
                if (handler.checkResult(result = handler.openLinkIssueDialog())) {
                    JiraTestLogIssueLabelProvider.this.addJiraIssueAndUpdateReport(activeShell, result);
                }
            }
        });
        this.registerHiddenListener(cell, jiraIssueMenu);
    }

    private JiraCreateIssueHandler newCreateIssueHandler(Shell activeShell) {
        return new JiraCreateIssueHandler(activeShell, this.view.getTestCaseLogRecord());
    }

    private void addJiraIssueAndUpdateReport(Shell activeShell, JiraIssueProgressResult result) {
        TestCaseLogRecord testCaseLogRecord = this.view.getTestCaseLogRecord();
        ReportEntity reportEntity = this.view.getReportEntity();
        JiraIssueCollection issueCollection = this.getJiraIssueCollection(testCaseLogRecord, reportEntity);
        issueCollection.getIssues().add(result.getJiraIssue());
        try {
            this.updateJiraReport(testCaseLogRecord, issueCollection, reportEntity);
        }
        catch (JiraIntegrationException e) {
            MessageDialog.openError((Shell)activeShell, (String)StringConstants.ERROR, (String)e.getMessage());
        }
    }

    private void registerHiddenListener(ViewerCell cell, final Menu jiraIssueMenu) {
        final Control control = cell.getControl();
        final Menu oldMenu = control.getMenu();
        control.setMenu(jiraIssueMenu);
        jiraIssueMenu.setVisible(true);
        jiraIssueMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                control.setMenu(oldMenu);
                jiraIssueMenu.removeMenuListener((MenuListener)this);
            }
        });
    }

    private int getIndexOfStepLogRecord(ViewerCell cell) {
        return Arrays.asList(this.view.getTestCaseLogRecord().getChildRecords()).indexOf(cell.getElement()) + 1;
    }

    protected Class<ILogRecord> getElementType() {
        return ILogRecord.class;
    }

    protected Image getImage(ILogRecord element) {
        return this.isMainStep(element) ? ImageConstants.IMG_ISSUE_HOVER_OUT : null;
    }

    protected Image getHoveredImage(ILogRecord element) {
        return this.isMainStep(element) ? ImageConstants.IMG_ISSUE_HOVER_IN : null;
    }

    protected String getText(ILogRecord element) {
        return "";
    }

    private boolean isMainStep(ILogRecord logRecord) {
        return logRecord instanceof TestStepLogRecord && ObjectUtils.equals((Object)this.view.getTestCaseLogRecord(), (Object)logRecord.getParentLogRecord());
    }

    protected boolean shouldShowCursor(ViewerCell cell, Point currentMouseLocation) {
        return super.shouldShowCursor(cell, currentMouseLocation) && this.isMainStep((ILogRecord)cell.getElement());
    }

    protected String getElementToolTipText(ILogRecord element) {
        return this.isMainStep(element) ? ComposerJiraIntegrationMessageConstant.CLMN_TOOLTIP_CLICK_TO_QUICK_CREATE_ISSUE : null;
    }
}

