/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.jira.report.dialog;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.jira.JiraUIComponent;
import com.kms.katalon.composer.integration.jira.constant.ComposerJiraIntegrationMessageConstant;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.integration.jira.JiraIntegrationException;
import com.kms.katalon.integration.jira.issue.IssueHTMLLinkProvider;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JiraIssueBrowserDialog
extends Dialog
implements JiraUIComponent {
    private Text txtBrowserUrl;
    protected Browser browser;
    private String issueKey;
    private IssueHTMLLinkProvider htmlLinkProvider;

    public JiraIssueBrowserDialog(Shell parentShell, TestCaseLogRecord logRecord, IssueHTMLLinkProvider htmlLinkProvider) throws URISyntaxException, IOException {
        super(parentShell);
        this.htmlLinkProvider = htmlLinkProvider;
    }

    protected int getShellStyle() {
        return 16464;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = 2;
        composite.setBackgroundMode(2);
        this.txtBrowserUrl = new Text(composite, 2056);
        this.txtBrowserUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(composite, 0);
        this.browser = new Browser(composite, 0);
        this.browser.setJavascriptEnabled(true);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        new Label(composite, 0);
        Label lblNotification = new Label(composite, 64);
        lblNotification.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblNotification.setText(ComposerJiraIntegrationMessageConstant.DIA_ISSUE_BROWSE_NOTIFICATION);
        this.registerControlModifyListeners();
        this.setInput();
        return composite;
    }

    private void setInput() {
        try {
            this.browser.setUrl(this.htmlLinkProvider.getLoginHTMLLink());
        }
        catch (IOException | URISyntaxException | GeneralSecurityException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void registerControlModifyListeners() {
        this.browser.addLocationListener(new LocationListener(){
            private boolean ready;
            private boolean dashBoardSet;
            private boolean loggedIn;

            public void changing(LocationEvent event) {
                JiraIssueBrowserDialog.this.txtBrowserUrl.setText(event.location);
            }

            public void changed(LocationEvent event) {
                try {
                    String location = JiraIssueBrowserDialog.this.browser.getUrl();
                    if (!this.ready) {
                        if (!this.loggedIn && JiraIssueBrowserDialog.this.isLoginPage()) {
                            this.loggedIn = true;
                            this.login();
                            return;
                        }
                        if (location.startsWith(JiraIssueBrowserDialog.this.htmlLinkProvider.getIssueUrlPrefix())) {
                            this.ready = true;
                            JiraIssueBrowserDialog.this.trigger();
                            return;
                        }
                        if (!this.dashBoardSet && !event.location.equals(JiraIssueBrowserDialog.this.htmlLinkProvider.getDashboardHTMLLink())) {
                            JiraIssueBrowserDialog.this.browser.setUrl(JiraIssueBrowserDialog.this.htmlLinkProvider.getDashboardHTMLLink());
                            JiraIssueBrowserDialog.this.browser.setUrl(JiraIssueBrowserDialog.this.htmlLinkProvider.getHTMLLink());
                            this.dashBoardSet = true;
                            return;
                        }
                        return;
                    }
                    this.getNewIssueKey(location);
                }
                catch (IOException | URISyntaxException | GeneralSecurityException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }

            private void login() throws IOException, URISyntaxException, GeneralSecurityException {
                if (JiraIssueBrowserDialog.this.isLoginDashboard()) {
                    JiraIssueBrowserDialog.this.loginForServer();
                } else {
                    JiraIssueBrowserDialog.this.loginForCloud();
                }
            }

            private void getNewIssueKey(String location) throws IOException, GeneralSecurityException {
                String createdIssueURLPrefix = JiraIssueBrowserDialog.this.getHTMLIssueURLPrefix();
                if (location.startsWith(createdIssueURLPrefix)) {
                    JiraIssueBrowserDialog.this.browser.removeLocationListener((LocationListener)this);
                    JiraIssueBrowserDialog.this.issueKey = location.substring(createdIssueURLPrefix.length() + 1);
                    JiraIssueBrowserDialog.this.close();
                }
            }
        });
    }

    private boolean isLoginDashboard() throws IOException, URISyntaxException, GeneralSecurityException {
        return this.htmlLinkProvider.getLoginHTMLLink().equals(this.browser.getUrl());
    }

    private boolean isLoginPage() throws IOException, URISyntaxException, GeneralSecurityException {
        return this.htmlLinkProvider.getLoginHTMLLink().startsWith(this.browser.getUrl());
    }

    protected void loginForCloud() {
        try {
            StringBuilder js = new StringBuilder().append("document.getElementById(\"username\").value = \"" + StringEscapeUtils.escapeEcmaScript((String)this.getCredential().getUsername()) + "\";\n").append("document.getElementById(\"password\").value = \"" + StringEscapeUtils.escapeEcmaScript((String)this.getCredential().getPassword()) + "\";\n").append("document.getElementById(\"remember-me\").checked = true;\n").append("document.getElementById(\"login\").click();\n");
            this.browser.execute(this.waitAndExec("remember-me", js.toString()));
        }
        catch (JiraIntegrationException | IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void loginForServer() {
        try {
            StringBuilder js = new StringBuilder();
            js.append("document.getElementById(\"login-form-username\").value = \"" + StringEscapeUtils.escapeEcmaScript((String)this.getCredential().getUsername()) + "\";\n").append("document.getElementById(\"login-form-password\").value = \"" + StringEscapeUtils.escapeEcmaScript((String)this.getCredential().getPassword()) + "\";\n").append("document.getElementById(\"login-form-remember-me\").checked = true;\n").append("document.getElementById(\"login-form-submit\").click();\n");
            this.browser.execute(this.waitAndExec("login-form-submit", js.toString()));
        }
        catch (JiraIntegrationException | IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected String waitAndExec(String element, String js) {
        return "function waitUntilExist() {if (document.getElementById(\"" + element + "\") === null) {" + "setTimeout(waitUntilExist, 1000);" + "} else {" + js + "}" + "};" + "waitUntilExist();";
    }

    protected void trigger() {
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected Point getInitialSize() {
        return new Point(1200, 800);
    }

    public boolean close() {
        this.browser.close();
        return super.close();
    }

    public String getIssueKey() {
        return this.issueKey;
    }
}

