/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.jira.report.dialog;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.jira.report.dialog.JiraIssueBrowserDialog;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.integration.jira.issue.IssueHTMLLinkProvider;
import com.kms.katalon.integration.jira.issue.IssueMetaDataProvider;
import com.kms.katalon.integration.jira.issue.NewSubtaskHTMLLinkProvider;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.swt.widgets.Shell;

public class CreateAsSubTaskBrowserDialog
extends JiraIssueBrowserDialog {
    private IssueMetaDataProvider issueMetaData;

    public CreateAsSubTaskBrowserDialog(Shell parentShell, TestCaseLogRecord logRecord, NewSubtaskHTMLLinkProvider htmlLinkProvider) throws URISyntaxException, IOException {
        super(parentShell, logRecord, (IssueHTMLLinkProvider)htmlLinkProvider);
        this.issueMetaData = htmlLinkProvider.getIssueMetaData();
    }

    @Override
    protected void trigger() {
        try {
            StringBuilder updateFieldsJS = new StringBuilder();
            if (this.getSettingStore().isUseTestCaseNameAsSummaryEnabled()) {
                updateFieldsJS.append(this.updateField("summary", this.issueMetaData.getSummary()));
            }
            updateFieldsJS.append(this.updateField("description", this.issueMetaData.getDescription()));
            this.browser.execute(this.waitAndExec("description", updateFieldsJS.toString()));
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private String updateField(String id, String value) {
        return "document.getElementById(\"" + id + "\").value = \"" + StringEscapeUtils.escapeEcmaScript((String)value) + "\";\n";
    }
}

