/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.jira.report;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.control.DropdownToolItemSelectionListener;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.integration.jira.JiraUIComponent;
import com.kms.katalon.composer.integration.jira.constant.ComposerJiraIntegrationMessageConstant;
import com.kms.katalon.composer.integration.jira.constant.StringConstants;
import com.kms.katalon.composer.integration.jira.report.JiraCreateIssueHandler;
import com.kms.katalon.composer.integration.jira.report.dialog.progress.JiraIssueProgressResult;
import com.kms.katalon.composer.integration.jira.report.provider.JiraIssueIDLabelProvider;
import com.kms.katalon.composer.integration.jira.report.provider.JiraIssueLabelProvider;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.integration.jira.entity.JiraIssue;
import com.kms.katalon.integration.jira.entity.JiraIssueCollection;
import com.kms.katalon.tracking.service.Trackings;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class JiraLinkedIssuesDialog
extends AbstractDialog
implements JiraUIComponent {
    public static final int CLMN_ID_IDEX = 0;
    public static final int CLMN_SUMMARY_IDEX = 1;
    public static final int CLMN_STATUS_IDEX = 2;
    private TableViewer tableViewer;
    private JiraIssueCollection jiraIssueCollection;
    private ToolItem tltmRemove;
    private ToolItem tltmEdit;
    private TestCaseLogRecord logRecord;
    private boolean changed;
    private JiraCreateIssueHandler createIssueHandler;

    public JiraLinkedIssuesDialog(Shell parentShell, JiraIssueCollection jiraIssueCollection, TestCaseLogRecord logRecord) {
        super(parentShell);
        this.jiraIssueCollection = jiraIssueCollection;
        this.logRecord = logRecord;
    }

    protected void registerControlModifyListeners() {
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structuredSelection = JiraLinkedIssuesDialog.this.tableViewer.getStructuredSelection();
                JiraLinkedIssuesDialog.this.tltmRemove.setEnabled(!structuredSelection.isEmpty());
                JiraLinkedIssuesDialog.this.tltmEdit.setEnabled(structuredSelection.size() == 1);
            }
        });
        this.tltmRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraLinkedIssuesDialog.this.jiraIssueCollection.getIssues().removeAll(JiraLinkedIssuesDialog.this.tableViewer.getStructuredSelection().toList());
                JiraLinkedIssuesDialog.this.tableViewer.refresh();
                JiraLinkedIssuesDialog.this.changed = true;
            }
        });
        this.tltmEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraLinkedIssuesDialog.this.openEditIssueDialog();
            }
        });
    }

    protected void setInput() {
        this.tableViewer.setInput((Object)this.jiraIssueCollection.getIssues());
        this.createIssueHandler = new JiraCreateIssueHandler(this.getShell(), this.logRecord);
    }

    protected Control createDialogContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createToolBar(composite);
        this.createTableCompiste(composite);
        return composite;
    }

    private void createTableCompiste(Composite composite) {
        Composite issueTableComposite = new Composite(composite, 0);
        issueTableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tableLayout = new TableColumnLayout();
        issueTableComposite.setLayout((Layout)tableLayout);
        this.tableViewer = new TableViewer(issueTableComposite, 67584);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewerColumn tableViewerColumnID = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnID = tableViewerColumnID.getColumn();
        tblclmnID.setText(StringConstants.ID);
        tableViewerColumnID.setLabelProvider((CellLabelProvider)new JiraIssueIDLabelProvider(0));
        tableLayout.setColumnData((Widget)tblclmnID, (ColumnLayoutData)new ColumnWeightData(20, 100));
        TableViewerColumn tableViewerColumnSummary = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnSummary = tableViewerColumnSummary.getColumn();
        tblclmnSummary.setText(ComposerJiraIntegrationMessageConstant.DIA_LBL_SUMMARY);
        tableViewerColumnSummary.setLabelProvider((CellLabelProvider)new JiraIssueLabelProvider(1));
        tableLayout.setColumnData((Widget)tblclmnSummary, (ColumnLayoutData)new ColumnWeightData(50, 150));
        TableViewerColumn tableViewerColumnStatus = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnStatus = tableViewerColumnStatus.getColumn();
        tblclmnStatus.setText(StringConstants.STATUS);
        tableViewerColumnStatus.setLabelProvider((CellLabelProvider)new JiraIssueLabelProvider(2));
        tableLayout.setColumnData((Widget)tblclmnStatus, (ColumnLayoutData)new ColumnWeightData(20, 150));
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
    }

    private void createToolBar(Composite composite) {
        ToolBar toolBar = new ToolBar(composite, 0x820000);
        toolBar.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        ToolItem tltmAdd = new ToolItem(toolBar, 4);
        tltmAdd.setText(StringConstants.ADD);
        tltmAdd.setImage(ImageConstants.IMG_16_ADD);
        tltmAdd.addSelectionListener((SelectionListener)new DropdownToolItemSelectionListener(){

            protected Menu getMenu() {
                Menu addMenu = new Menu((Control)JiraLinkedIssuesDialog.this.getShell());
                MenuItem newIssueItem = new MenuItem(addMenu, 8);
                newIssueItem.setText(ComposerJiraIntegrationMessageConstant.DIA_ITEM_CREATE_NEW_JIRA_ISSUE);
                newIssueItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Trackings.trackClickCreateNewJiraIssue();
                        JiraLinkedIssuesDialog.this.openNewIssueDialog();
                    }
                });
                MenuItem newAsSubTaskItem = new MenuItem(addMenu, 8);
                newAsSubTaskItem.setText(ComposerJiraIntegrationMessageConstant.DIA_ITEM_CREATE_AS_SUB_TASK);
                newAsSubTaskItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Trackings.trackClickCreateJiraSubIssue();
                        JiraLinkedIssuesDialog.this.openCreateAsSubTaskDialog();
                    }
                });
                MenuItem linkIssueItem = new MenuItem(addMenu, 8);
                linkIssueItem.setText(ComposerJiraIntegrationMessageConstant.DIA_ITEM_LINK_TO_JIRA_ISSUE);
                linkIssueItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Trackings.trackClickLinkToExistingJiraIssue();
                        JiraLinkedIssuesDialog.this.openLinkIssueDialog();
                    }
                });
                return addMenu;
            }
        });
        this.tltmEdit = new ToolItem(toolBar, 0);
        this.tltmEdit.setImage(ImageConstants.IMG_16_EDIT);
        this.tltmEdit.setText(StringConstants.EDIT);
        this.tltmEdit.setEnabled(false);
        this.tltmRemove = new ToolItem(toolBar, 0);
        this.tltmRemove.setImage(ImageConstants.IMG_16_REMOVE);
        this.tltmRemove.setText(StringConstants.REMOVE);
        this.tltmRemove.setEnabled(false);
    }

    private int getNumSteps() {
        return this.logRecord.getChildRecords().length;
    }

    private void openEditIssueDialog() {
        JiraIssue oldIssue = (JiraIssue)this.tableViewer.getStructuredSelection().getFirstElement();
        JiraIssueProgressResult handlerResult = this.createIssueHandler.openEditIssueDialog(oldIssue);
        if (this.createIssueHandler.checkResult(handlerResult)) {
            Collections.replaceAll(this.jiraIssueCollection.getIssues(), oldIssue, handlerResult.getJiraIssue());
            this.tableViewer.refresh();
        }
    }

    public void openCreateAsSubTaskDialog() {
        JiraIssueProgressResult handlerResult = this.createIssueHandler.openCreateAsSubTaskDialog(this.getNumSteps());
        this.checkResultAndUpdateTable(handlerResult);
    }

    public void openLinkIssueDialog() {
        JiraIssueProgressResult handlerResult = this.createIssueHandler.openLinkIssueDialog();
        if (!this.createIssueHandler.checkResult(handlerResult)) {
            return;
        }
        JiraIssue newJiraIssue = handlerResult.getJiraIssue();
        this.addIssueToCollection(newJiraIssue);
        this.refreshAndSetSelection(newJiraIssue);
    }

    private JiraIssue addIssueToCollection(JiraIssue newIssue) {
        int index = this.indexInCollection(newIssue, this.jiraIssueCollection);
        List issues = this.jiraIssueCollection.getIssues();
        if (index >= 0) {
            issues.remove(index);
            issues.add(index, newIssue);
        } else {
            issues.add(newIssue);
        }
        return newIssue;
    }

    private int indexInCollection(JiraIssue newIssue, JiraIssueCollection issueCollection) {
        List listIssues = issueCollection.getIssues();
        int index = 0;
        while (index < listIssues.size()) {
            if (newIssue.getKey().equals(((JiraIssue)listIssues.get(index)).getKey())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void openNewIssueDialog() {
        JiraIssueProgressResult handlerResult = this.createIssueHandler.openNewIssueDialog(this.getNumSteps());
        this.checkResultAndUpdateTable(handlerResult);
    }

    private void checkResultAndUpdateTable(JiraIssueProgressResult result) {
        if (this.createIssueHandler.checkResult(result)) {
            JiraIssue newJiraIssue = result.getJiraIssue();
            this.jiraIssueCollection.getIssues().add(newJiraIssue);
            this.refreshAndSetSelection(newJiraIssue);
        }
    }

    private void refreshAndSetSelection(JiraIssue newJiraIssue) {
        this.tableViewer.refresh();
        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)newJiraIssue));
        this.changed = true;
    }

    protected Point getInitialSize() {
        return new Point(500, 400);
    }

    public String getDialogTitle() {
        return ComposerJiraIntegrationMessageConstant.DIA_TITLE_LINKED_JIRA_ISSUES;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public JiraIssueCollection getJiraIssueCollection() {
        return this.jiraIssueCollection;
    }
}

