/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.jira.report;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.jira.JiraUIComponent;
import com.kms.katalon.composer.integration.jira.constant.ComposerJiraIntegrationMessageConstant;
import com.kms.katalon.composer.integration.jira.report.dialog.CreateAsSubTaskBrowserDialog;
import com.kms.katalon.composer.integration.jira.report.dialog.JiraIssueBrowserDialog;
import com.kms.katalon.composer.integration.jira.report.dialog.LinkJiraIssueDialog;
import com.kms.katalon.composer.integration.jira.report.dialog.progress.JiraIssueProgressResult;
import com.kms.katalon.composer.integration.jira.report.dialog.progress.LinkJiraIssueProgressDialog;
import com.kms.katalon.composer.integration.jira.report.dialog.progress.NewIssueProgressDialog;
import com.kms.katalon.composer.integration.jira.report.dialog.progress.UpdateJiraIssueProgressDialog;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.integration.jira.JiraIntegrationException;
import com.kms.katalon.integration.jira.entity.JiraIssue;
import com.kms.katalon.integration.jira.issue.EditIssueHTMLLinkProvider;
import com.kms.katalon.integration.jira.issue.IssueHTMLLinkProvider;
import com.kms.katalon.integration.jira.issue.NewIssueHTMLLinkProvider;
import com.kms.katalon.integration.jira.issue.NewSubtaskHTMLLinkProvider;
import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.swt.widgets.Shell;

public class JiraCreateIssueHandler
implements JiraUIComponent {
    private Shell shell;
    private TestCaseLogRecord logRecord;

    public JiraCreateIssueHandler(Shell shell, TestCaseLogRecord logRecord) {
        this.shell = shell;
        this.logRecord = logRecord;
    }

    public JiraIssueProgressResult openLinkIssueDialog() {
        LinkJiraIssueDialog linkDialog = new LinkJiraIssueDialog(this.shell, ComposerJiraIntegrationMessageConstant.DIA_TITLE_LINK_TO_EXISTING_ISSUE, ComposerJiraIntegrationMessageConstant.DIA_MESSAGE_LINK_TO_EXISTING_ISSUE, ComposerJiraIntegrationMessageConstant.DIA_LBL_LINK_TO_EXISTING_ISSUE);
        if (linkDialog.open() != 0) {
            return null;
        }
        return new LinkJiraIssueProgressDialog(this.shell, linkDialog.getIssueKey(), this.logRecord).run();
    }

    public JiraIssueProgressResult openNewIssueDialog(int numSteps) {
        try {
            return this.openNewIssueBrowserDialog(new JiraIssueBrowserDialog(this.shell, this.logRecord, (IssueHTMLLinkProvider)new NewIssueHTMLLinkProvider(this.logRecord, numSteps, this.getSettingStore())));
        }
        catch (IOException | URISyntaxException ex) {
            LoggerSingleton.logError((Throwable)ex);
            return null;
        }
    }

    private JiraIssueProgressResult openNewIssueBrowserDialog(JiraIssueBrowserDialog browserDialog) {
        if (browserDialog.open() != 0) {
            return null;
        }
        String issueKey = browserDialog.getIssueKey();
        return new NewIssueProgressDialog(this.shell, issueKey, this.logRecord).run();
    }

    public JiraIssueProgressResult openCreateAsSubTaskDialog(int numSteps) {
        String issueKey;
        block7: {
            CreateAsSubTaskBrowserDialog browserDialog;
            JiraIssue parentIssue;
            block6: {
                LinkJiraIssueDialog linkDialog = new LinkJiraIssueDialog(this.shell, ComposerJiraIntegrationMessageConstant.DIA_TITLE_CREATE_NEW_AS_SUB_TASK, ComposerJiraIntegrationMessageConstant.DIA_MESSAGE_CREATE_NEW_AS_SUB_TASK, ComposerJiraIntegrationMessageConstant.DIA_LBL_CREATE_NEW_AS_SUB_TASK);
                if (linkDialog.open() != 0) {
                    return null;
                }
                JiraIssueProgressResult result = new UpdateJiraIssueProgressDialog(this.shell, linkDialog.getIssueKey(), this.logRecord).run();
                if (!this.checkResult(result)) {
                    return null;
                }
                parentIssue = result.getJiraIssue();
                browserDialog = new CreateAsSubTaskBrowserDialog(this.shell, this.logRecord, new NewSubtaskHTMLLinkProvider(this.logRecord, this.getSettingStore(), parentIssue));
                if (browserDialog.open() == 0) break block6;
                return null;
            }
            issueKey = browserDialog.getIssueKey();
            if (!parentIssue.getKey().equals(issueKey)) break block7;
            return null;
        }
        try {
            return new NewIssueProgressDialog(this.shell, issueKey, this.logRecord).run();
        }
        catch (IOException | URISyntaxException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    public boolean checkResult(JiraIssueProgressResult result) {
        if (result == null) {
            return false;
        }
        if (result.hasError()) {
            JiraIntegrationException error = result.getError();
            MultiStatusErrorDialog.showErrorDialog((Throwable)error, (String)error.getMessage(), (String)error.getMessage());
            LoggerSingleton.logError((Throwable)error);
            return false;
        }
        return result.isComplete();
    }

    public JiraIssueProgressResult openEditIssueDialog(JiraIssue jiraIssue) {
        JiraIssueBrowserDialog browserDialog;
        block3: {
            browserDialog = new JiraIssueBrowserDialog(this.shell, this.logRecord, (IssueHTMLLinkProvider)new EditIssueHTMLLinkProvider(this.logRecord, this.getSettingStore(), jiraIssue));
            if (browserDialog.open() == 0) break block3;
            return null;
        }
        try {
            return new UpdateJiraIssueProgressDialog(this.shell, browserDialog.getIssueKey(), this.logRecord).run();
        }
        catch (IOException | ClassCastException | URISyntaxException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }
}

