/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.jira.preference;

import com.atlassian.jira.rest.client.api.domain.User;
import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.integration.jira.JiraUIComponent;
import com.kms.katalon.composer.integration.jira.constant.ComposerJiraIntegrationMessageConstant;
import com.kms.katalon.composer.integration.jira.constant.StringConstants;
import com.kms.katalon.composer.integration.jira.preference.DisplayedComboboxObject;
import com.kms.katalon.composer.integration.jira.preference.DisplayedIssueTypeComboboxObject;
import com.kms.katalon.composer.integration.jira.preference.JiraConnectionJob;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.integration.jira.JiraCredential;
import com.kms.katalon.integration.jira.entity.JiraIssueType;
import com.kms.katalon.integration.jira.entity.JiraProject;
import com.kms.katalon.integration.jira.setting.JiraIntegrationSettingStore;
import com.kms.katalon.integration.jira.setting.StoredJiraObject;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JiraSettingsComposite
implements JiraUIComponent {
    private Composite container;
    private Composite enablerComposite;
    private Button chckEnableIntegration;
    private Composite mainComposite;
    private Text txtServerUrl;
    private Text txtUsername;
    private Text txtPassword;
    private Button chckUseTestCaseNameAsSumarry;
    private Button chckAttachScreenshot;
    private Button chckAttachLog;
    private JiraIntegrationSettingStore settingStore = new JiraIntegrationSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
    private Button btnConnect;
    private Combo cbbIssueTypes;
    private Combo cbbProjects;
    private DisplayedComboboxObject<JiraProject> displayedJiraProject;
    private DisplayedComboboxObject<JiraIssueType> displayedJiraIssueType;
    private User user;
    private Shell shell;
    private Button chckAutoSubmitTestResult;
    private Button chckEncrypt;
    Button btnGetPlugin;
    private Composite settingComposite;
    private Composite overridedComposite;
    private StackLayout stackLayout;

    public void registerControlModifyListeners() {
        this.chckEnableIntegration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraSettingsComposite.this.enableIntegrationComposite();
            }
        });
        this.btnConnect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = JiraSettingsComposite.this.getShell();
                JiraConnectionJob job = new JiraConnectionJob(shell, JiraSettingsComposite.this.getEdittingCredential());
                JiraConnectionJob.JiraConnectionResult result = job.run();
                if (result.getError() != null) {
                    MessageDialog.openError((Shell)shell, (String)StringConstants.ERROR, (String)result.getError().getMessage());
                    return;
                }
                if (!result.isComplete()) {
                    return;
                }
                JiraSettingsComposite.this.user = result.getUser();
                JiraSettingsComposite.this.displayedJiraProject = result.getJiraProjects().updateDefaultURIFrom(JiraSettingsComposite.this.displayedJiraProject);
                JiraSettingsComposite.this.updateCombobox(JiraSettingsComposite.this.cbbProjects, JiraSettingsComposite.this.displayedJiraProject);
                JiraSettingsComposite.this.displayedJiraIssueType = result.getJiraIssueTypes().updateDefaultURIFrom(JiraSettingsComposite.this.displayedJiraIssueType);
                JiraSettingsComposite.this.updateCombobox(JiraSettingsComposite.this.cbbIssueTypes, JiraSettingsComposite.this.displayedJiraIssueType);
                MessageDialog.openInformation((Shell)shell, (String)StringConstants.INFO, (String)MessageFormat.format(ComposerJiraIntegrationMessageConstant.PREF_MSG_ACCOUNT_CONNECTED, result.getUser().getDisplayName()));
            }
        });
        this.btnGetPlugin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"https://store.katalon.com/product/3/Jira-Integration");
                Trackings.trackQuickDiscussion();
            }
        });
    }

    private void maskPasswordField() {
        this.txtPassword.setEchoChar("\u2022".charAt(0));
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    private Shell getShell() {
        return this.shell;
    }

    private void enableIntegrationComposite() {
        ControlUtils.recursiveSetEnabled((Control)this.mainComposite, (boolean)this.chckEnableIntegration.getSelection());
    }

    public void initializeData() {
        try {
            if (this.isJiraPluginEnabled()) {
                this.stackLayout.topControl = this.overridedComposite;
                return;
            }
            this.stackLayout.topControl = this.settingComposite;
            this.chckEnableIntegration.setSelection(this.settingStore.isIntegrationEnabled());
            this.enableIntegrationComposite();
            boolean encryptionEnabled = this.settingStore.isEncryptionEnabled();
            this.txtServerUrl.setText(this.settingStore.getServerUrl(encryptionEnabled));
            this.txtUsername.setText(this.settingStore.getUsername(encryptionEnabled));
            this.txtPassword.setText(this.settingStore.getPassword(encryptionEnabled));
            this.chckEncrypt.setSelection(encryptionEnabled);
            this.maskPasswordField();
            this.chckUseTestCaseNameAsSumarry.setSelection(this.settingStore.isUseTestCaseNameAsSummaryEnabled());
            this.chckAttachScreenshot.setSelection(this.settingStore.isAttachScreenshotEnabled());
            this.chckAttachLog.setSelection(this.settingStore.isAttachLogEnabled());
            this.chckAutoSubmitTestResult.setSelection(this.settingStore.isSubmitTestResultAutomatically());
            this.displayedJiraProject = new DisplayedComboboxObject(this.settingStore.getStoredJiraProject());
            this.updateCombobox(this.cbbProjects, this.displayedJiraProject);
            this.displayedJiraIssueType = new DisplayedIssueTypeComboboxObject((StoredJiraObject<JiraIssueType>)this.settingStore.getStoredJiraIssueType());
            this.updateCombobox(this.cbbIssueTypes, this.displayedJiraIssueType);
            this.user = this.settingStore.getJiraUser();
        }
        catch (IOException | GeneralSecurityException e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.ERROR, (String)e.getMessage());
        }
    }

    private void updateCombobox(Combo combobox, DisplayedComboboxObject<?> displayedJiraObject) {
        combobox.setItems(displayedJiraObject.getNames());
        int defaultProjectIndex = displayedJiraObject.getDefaultObjectIndex();
        if (defaultProjectIndex >= 0) {
            combobox.select(defaultProjectIndex);
        }
    }

    public Composite createContainer(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout());
        Composite contentComposite = new Composite(this.container, 0);
        contentComposite.setLayoutData((Object)new GridData(1808));
        this.stackLayout = new StackLayout();
        contentComposite.setLayout((Layout)this.stackLayout);
        this.overridedComposite = new Composite(contentComposite, 0);
        this.overridedComposite.setLayout((Layout)new GridLayout());
        Label lblOverriedSetting = new Label(this.overridedComposite, 64);
        lblOverriedSetting.setText(ComposerJiraIntegrationMessageConstant.JiraSettingsComposite_MSG_MOVE_SETTINGS);
        lblOverriedSetting.setBackground(ColorUtil.getWarningLogBackgroundColor());
        GridData ldOverrideMessage = new GridData(4, 128, true, false);
        ldOverrideMessage.widthHint = 300;
        lblOverriedSetting.setLayoutData((Object)ldOverrideMessage);
        this.settingComposite = new Composite(contentComposite, 0);
        this.settingComposite.setLayout((Layout)this.noneMarginGridLayout());
        this.createjiraPlugin(this.settingComposite);
        this.enablerComposite = new Composite(this.settingComposite, 0);
        this.enablerComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.enablerComposite.setLayout((Layout)new GridLayout());
        this.chckEnableIntegration = new Button(this.enablerComposite, 32);
        this.chckEnableIntegration.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.chckEnableIntegration.setText(ComposerJiraIntegrationMessageConstant.PREF_CHCK_ENABLE_INTEGRATION);
        this.mainComposite = new Composite(this.settingComposite, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout glMainComposite = new GridLayout(1, false);
        glMainComposite.marginWidth = 0;
        glMainComposite.marginHeight = 0;
        this.mainComposite.setLayout((Layout)glMainComposite);
        this.createAuthenticationGroup();
        this.createSubmitOptionsGroup();
        return this.container;
    }

    private GridLayout noneMarginGridLayout() {
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        return gl;
    }

    private void createjiraPlugin(Composite parent) {
        Composite deprecatedComposite = new Composite(parent, 0);
        deprecatedComposite.setLayout((Layout)this.noneMarginGridLayout());
        deprecatedComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        deprecatedComposite.setLayout((Layout)new GridLayout());
        Group grpJiraPlugin = new Group(deprecatedComposite, 0);
        grpJiraPlugin.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout glGrpJiraPlugin = new GridLayout(1, false);
        glGrpJiraPlugin.horizontalSpacing = 10;
        glGrpJiraPlugin.marginWidth = 10;
        GridData layoutData = new GridData(4, 128, true, false);
        layoutData.widthHint = 300;
        grpJiraPlugin.setLayout((Layout)glGrpJiraPlugin);
        grpJiraPlugin.setText("");
        Label deprecatedMessage = new Label((Composite)grpJiraPlugin, 64);
        deprecatedMessage.setLayoutData((Object)layoutData);
        deprecatedMessage.setImage(ImageConstants.IMG_20_WARNING_MSG);
        deprecatedMessage.setText(ComposerJiraIntegrationMessageConstant.JiraSettingsComposite_MSG_DEPRECATED);
        deprecatedMessage.setBackground(ColorUtil.getWarningLogBackgroundColor());
        new Label((Composite)grpJiraPlugin, 0);
        this.btnGetPlugin = new Button((Composite)grpJiraPlugin, 0);
        this.btnGetPlugin.setLayoutData((Object)new GridData(131072, 0x1000000, true, true, 1, 1));
        this.btnGetPlugin.setText(ComposerJiraIntegrationMessageConstant.PREF_LBL_GETJIRAPLUGIN);
    }

    private void createAuthenticationGroup() {
        Group grpAuthentication = new Group(this.mainComposite, 0);
        grpAuthentication.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout glGrpAuthentication = new GridLayout(2, false);
        glGrpAuthentication.horizontalSpacing = 15;
        grpAuthentication.setLayout((Layout)glGrpAuthentication);
        grpAuthentication.setText(ComposerJiraIntegrationMessageConstant.PREF_TITLE_AUTHENTICATION);
        Label lblServerUrl = new Label((Composite)grpAuthentication, 0);
        lblServerUrl.setText(ComposerJiraIntegrationMessageConstant.PREF_LBL_SERVER_URL);
        this.txtServerUrl = new Text((Composite)grpAuthentication, 2048);
        this.txtServerUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblUsername = new Label((Composite)grpAuthentication, 0);
        lblUsername.setText(ComposerJiraIntegrationMessageConstant.PREF_LBL_USERNAME);
        this.txtUsername = new Text((Composite)grpAuthentication, 2048);
        this.txtUsername.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPassword = new Label((Composite)grpAuthentication, 0);
        lblPassword.setText(ComposerJiraIntegrationMessageConstant.PREF_LBL_PASSWORD);
        Composite passwordComposite = new Composite((Composite)grpAuthentication, 0);
        passwordComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glPassword = new GridLayout(1, false);
        glPassword.marginWidth = 0;
        glPassword.marginHeight = 0;
        passwordComposite.setLayout((Layout)glPassword);
        this.txtPassword = new Text(passwordComposite, 2048);
        this.txtPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.chckEncrypt = new Button((Composite)grpAuthentication, 32);
        this.chckEncrypt.setLayoutData((Object)new GridData(16384, 0x1000000, false, true, 2, 1));
        this.chckEncrypt.setText(ComposerJiraIntegrationMessageConstant.PREF_CHCK_ENCRYPT_PASSWORD);
        this.btnConnect = new Button((Composite)grpAuthentication, 0);
        this.btnConnect.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnConnect.setText(ComposerJiraIntegrationMessageConstant.PREF_LBL_CONNECT);
        new Label((Composite)grpAuthentication, 0);
    }

    private void createSubmitOptionsGroup() {
        Group grpSubmitOptions = new Group(this.mainComposite, 0);
        grpSubmitOptions.setText(ComposerJiraIntegrationMessageConstant.PREF_TITLE_SUBMIT_OPTIONS);
        grpSubmitOptions.setLayout((Layout)new GridLayout(1, false));
        grpSubmitOptions.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite projectAndIssueComposite = new Composite((Composite)grpSubmitOptions, 0);
        projectAndIssueComposite.setLayout((Layout)new GridLayout(2, false));
        projectAndIssueComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label lblDefaultJiraProject = new Label(projectAndIssueComposite, 0);
        lblDefaultJiraProject.setText(ComposerJiraIntegrationMessageConstant.PREF_LBL_DF_JIRA_PROJECT);
        this.cbbProjects = new Combo(projectAndIssueComposite, 8);
        this.cbbProjects.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblDefaultJiraIssue = new Label(projectAndIssueComposite, 0);
        lblDefaultJiraIssue.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDefaultJiraIssue.setText(ComposerJiraIntegrationMessageConstant.PREF_LBL_DF_JIRA_ISSUE_TYPE);
        this.cbbIssueTypes = new Combo(projectAndIssueComposite, 8);
        this.cbbIssueTypes.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite submitOptionsComposite = new Composite((Composite)grpSubmitOptions, 0);
        submitOptionsComposite.setLayout((Layout)new GridLayout(1, false));
        submitOptionsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.chckUseTestCaseNameAsSumarry = new Button(submitOptionsComposite, 32);
        this.chckUseTestCaseNameAsSumarry.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.chckUseTestCaseNameAsSumarry.setText(ComposerJiraIntegrationMessageConstant.PREF_CHCK_USE_TEST_CASE_NAME_AS_SUMMARY);
        this.chckAttachScreenshot = new Button(submitOptionsComposite, 32);
        this.chckAttachScreenshot.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.chckAttachScreenshot.setText(ComposerJiraIntegrationMessageConstant.PREF_CHCK_ATTACH_SCREENSHOT_TO_JIRA_TICKET);
        this.chckAttachLog = new Button(submitOptionsComposite, 32);
        this.chckAttachLog.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.chckAttachLog.setText(ComposerJiraIntegrationMessageConstant.PREF_CHCK_ATTACH_LOG_TO_JIRA_TICKET);
        this.chckAutoSubmitTestResult = new Button(submitOptionsComposite, 32);
        this.chckAutoSubmitTestResult.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.chckAutoSubmitTestResult.setText(ComposerJiraIntegrationMessageConstant.PREF_CHCK_AUTO_SUBMIT_TEST_RESULT);
    }

    public boolean okPressed() {
        block3: {
            if (!this.isJiraPluginEnabled()) break block3;
            return true;
        }
        try {
            this.settingStore.enableIntegration(this.chckEnableIntegration.getSelection());
            boolean encryptionEnable = this.chckEncrypt.getSelection();
            this.settingStore.saveServerUrl(this.getTrimedValue(this.txtServerUrl), encryptionEnable);
            this.settingStore.saveUsername(this.getTrimedValue(this.txtUsername), encryptionEnable);
            this.settingStore.savePassword(this.txtPassword.getText(), encryptionEnable);
            this.settingStore.saveJiraUser(this.user);
            this.settingStore.enableEncryption(encryptionEnable);
            this.settingStore.enableUseTestCaseNameAsSummary(this.chckUseTestCaseNameAsSumarry.getSelection());
            this.settingStore.enableAttachScreenshot(this.chckAttachScreenshot.getSelection());
            this.settingStore.enableAttachLog(this.chckAttachLog.getSelection());
            this.settingStore.enableSubmitTestResultAutomatically(this.chckAutoSubmitTestResult.getSelection());
            this.displayedJiraProject.setDefaultObjectIndex(this.cbbProjects.getSelectionIndex());
            this.settingStore.saveStoredJiraProject(this.displayedJiraProject.getStoredObject());
            this.displayedJiraIssueType.setDefaultObjectIndex(this.cbbIssueTypes.getSelectionIndex());
            this.settingStore.saveStoredJiraIssueType(this.displayedJiraIssueType.getStoredObject());
            return true;
        }
        catch (IOException | GeneralSecurityException e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.ERROR, (String)e.getMessage());
            return false;
        }
    }

    private JiraCredential getEdittingCredential() {
        JiraCredential credential = new JiraCredential();
        credential.setServerUrl(this.getTrimedValue(this.txtServerUrl));
        credential.setUsername(this.getTrimedValue(this.txtUsername));
        credential.setPassword(this.txtPassword.getText());
        return credential;
    }

    private String getTrimedValue(Text text) {
        return StringUtils.defaultString((String)text.getText()).trim();
    }
}

