/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.jira.preference;

import com.google.gson.reflect.TypeToken;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;

public class JiraPreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        JiraPreferenceInitializer.getStore().setDefault("lastEditedJiraJQL", JsonUtil.toJson(Collections.emptyMap(), (Type)JiraPreferenceInitializer.getTokenTypeForMap(), (boolean)false));
    }

    private static Type getTokenTypeForMap() {
        return new TypeToken<Map<String, String>>(){}.getType();
    }

    public static ScopedPreferenceStore getStore() {
        return PreferenceStoreManager.getPreferenceStore(JiraPreferenceInitializer.class);
    }

    public static String getLastEditedJQL(ProjectEntity project) {
        String key;
        if (project == null) {
            return "";
        }
        Map<String, String> jqlPerProjects = JiraPreferenceInitializer.getJqlPerProjects();
        return jqlPerProjects.containsKey(key = project.getFolderLocation()) ? jqlPerProjects.get(key) : "";
    }

    private static Map<String, String> getJqlPerProjects() {
        return (Map)JsonUtil.fromJson((String)JiraPreferenceInitializer.getStore().getString("lastEditedJiraJQL"), (Type)JiraPreferenceInitializer.getTokenTypeForMap());
    }

    public static void saveLastEditedJQL(String jql, ProjectEntity project) throws IOException {
        if (jql == null || project == null) {
            return;
        }
        Map<String, String> jqlPerProjects = JiraPreferenceInitializer.getJqlPerProjects();
        jqlPerProjects.put(project.getFolderLocation(), jql);
        ScopedPreferenceStore store = JiraPreferenceInitializer.getStore();
        store.setValue("lastEditedJiraJQL", JsonUtil.toJson(jqlPerProjects, (Type)JiraPreferenceInitializer.getTokenTypeForMap(), (boolean)false));
        store.save();
    }
}

