/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.jira.preference;

import com.atlassian.jira.rest.client.api.AddressableEntity;
import com.atlassian.jira.rest.client.api.domain.User;
import com.kms.katalon.composer.integration.jira.JiraProgressDialog;
import com.kms.katalon.composer.integration.jira.JiraProgressResult;
import com.kms.katalon.composer.integration.jira.constant.ComposerJiraIntegrationMessageConstant;
import com.kms.katalon.composer.integration.jira.preference.DisplayedComboboxObject;
import com.kms.katalon.composer.integration.jira.preference.DisplayedIssueTypeComboboxObject;
import com.kms.katalon.integration.jira.JiraCredential;
import com.kms.katalon.integration.jira.JiraIntegrationAuthenticationHandler;
import com.kms.katalon.integration.jira.JiraIntegrationException;
import com.kms.katalon.integration.jira.entity.JiraIssueType;
import com.kms.katalon.integration.jira.entity.JiraProject;
import com.kms.katalon.integration.jira.setting.StoredJiraObject;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class JiraConnectionJob
extends JiraProgressDialog {
    private JiraCredential credential;
    private JiraConnectionResult result;
    private JiraIntegrationAuthenticationHandler handler;

    public JiraConnectionJob(Shell parent, JiraCredential credential) {
        super(parent);
        this.credential = credential;
        this.handler = new JiraIntegrationAuthenticationHandler();
    }

    @Override
    public JiraConnectionResult run() {
        this.result = new JiraConnectionResult();
        try {
            this.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(ComposerJiraIntegrationMessageConstant.JOB_TASK_JIRA_CONNECTION, 3);
                    try {
                        try {
                            monitor.subTask(ComposerJiraIntegrationMessageConstant.JOB_SUB_TASK_VALIDATING_ACCOUNT);
                            JiraConnectionJob.this.validateJiraAccount();
                            monitor.worked(1);
                            JiraConnectionJob.this.checkCanceled(monitor);
                            monitor.subTask(ComposerJiraIntegrationMessageConstant.JOB_SUB_TASK_FETCHING_PROJECTS);
                            JiraConnectionJob.this.getJiraProjects();
                            monitor.worked(1);
                            JiraConnectionJob.this.checkCanceled(monitor);
                            monitor.subTask(ComposerJiraIntegrationMessageConstant.JOB_SUB_TASK_FETCHING_ISSUE_TYPES);
                            JiraConnectionJob.this.getJiraIssueTypes();
                            monitor.worked(1);
                            JiraConnectionJob.this.result.setComplete(true);
                        }
                        catch (JiraIntegrationException e) {
                            JiraConnectionJob.this.result.setError(e);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {}
        return this.result;
    }

    private void validateJiraAccount() throws JiraIntegrationException {
        this.result.setUser(this.handler.authenticate(this.credential));
    }

    private void getJiraProjects() throws JiraIntegrationException {
        this.result.setJiraProjects(this.handler.getJiraProjects(this.credential));
    }

    private void getJiraIssueTypes() throws JiraIntegrationException {
        this.result.setJiraIssueTypes(this.handler.getJiraIssuesTypes(this.credential));
    }

    public class JiraConnectionResult
    extends JiraProgressResult {
        private User user;
        private DisplayedComboboxObject<JiraProject> jiraProjects;
        private DisplayedComboboxObject<JiraIssueType> jiraIssueTypes;

        public JiraConnectionResult() {
            this.setComplete(false);
        }

        public User getUser() {
            return this.user;
        }

        public void setUser(User user) {
            this.user = user;
        }

        public void setJiraProjects(JiraProject[] jiraProjects) {
            this.jiraProjects = new DisplayedComboboxObject(new StoredJiraObject(null, (AddressableEntity[])jiraProjects));
        }

        public DisplayedComboboxObject<JiraIssueType> getJiraIssueTypes() {
            return this.jiraIssueTypes;
        }

        public void setJiraIssueTypes(JiraIssueType[] jiraIssueTypes) {
            this.jiraIssueTypes = new DisplayedIssueTypeComboboxObject((StoredJiraObject<JiraIssueType>)new StoredJiraObject(null, (AddressableEntity[])jiraIssueTypes));
        }

        public DisplayedComboboxObject<JiraProject> getJiraProjects() {
            return this.jiraProjects;
        }
    }
}

