/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.jira.preference;

import com.atlassian.jira.rest.client.api.AddressableEntity;
import com.atlassian.jira.rest.client.api.NamedEntity;
import com.kms.katalon.composer.integration.jira.preference.PreferredObjectStrategy;
import com.kms.katalon.integration.jira.setting.StoredJiraObject;
import java.net.URI;
import java.util.Arrays;

public class DisplayedComboboxObject<T extends NamedEntity & AddressableEntity>
implements PreferredObjectStrategy {
    private StoredJiraObject<T> storedObject;
    private String[] names;

    public DisplayedComboboxObject(StoredJiraObject<T> storedObject) {
        this.storedObject = storedObject;
        this.buildNameArray();
    }

    public StoredJiraObject<T> getStoredObject() {
        return this.storedObject;
    }

    public String[] getNames() {
        if (this.names == null) {
            return new String[0];
        }
        return this.names;
    }

    private void buildNameArray() {
        NamedEntity[] jiraObjects = (NamedEntity[])this.storedObject.getJiraObjects();
        if (jiraObjects == null) {
            return;
        }
        int arrayLength = jiraObjects.length;
        this.names = new String[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            this.names[i] = jiraObjects[i].getName();
            ++i;
        }
    }

    public int getDefaultObjectIndex() {
        NamedEntity defaultJiraProject = (NamedEntity)this.storedObject.getDefaultJiraObject();
        if (defaultJiraProject != null) {
            return Arrays.asList((NamedEntity[])this.storedObject.getJiraObjects()).indexOf(defaultJiraProject);
        }
        if (this.storedObject.getJiraObjects() == null) {
            return -1;
        }
        int preferredIndex = this.getPreferredIndex();
        this.setDefaultObjectIndex(preferredIndex);
        return preferredIndex;
    }

    public void setDefaultObjectIndex(int index) {
        if (this.storedObject.getJiraObjects() == null) {
            return;
        }
        this.setDefaultObjectURI(((AddressableEntity)((NamedEntity[])this.storedObject.getJiraObjects())[index]).getSelf());
    }

    private void setDefaultObjectURI(URI uri) {
        this.storedObject.setDefaultURI(uri);
    }

    public DisplayedComboboxObject<T> updateDefaultURIFrom(DisplayedComboboxObject<T> that) {
        this.setDefaultObjectURI(that.getStoredObject().getDefaultProjectURI());
        return this;
    }

    @Override
    public int getPreferredIndex() {
        return 0;
    }
}

