/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.jira;

import com.kms.katalon.composer.report.lookup.LogRecordLookup;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.integration.jira.JiraComponent;
import com.kms.katalon.integration.jira.JiraIntegrationException;
import com.kms.katalon.integration.jira.entity.JiraIssue;
import com.kms.katalon.integration.jira.entity.JiraIssueCollection;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;

public interface JiraUIComponent
extends JiraComponent {
    default public String getHTMLIssueURLPrefix() throws IOException, GeneralSecurityException {
        return String.valueOf(this.getSettingStore().getServerUrl(this.getSettingStore().isEncryptionEnabled())) + "/browse";
    }

    default public URI getHTMLLink(JiraIssue jiraIssue) throws URISyntaxException, IOException, GeneralSecurityException {
        return new URI(String.valueOf(this.getHTMLIssueURLPrefix()) + "/" + jiraIssue.getKey());
    }

    default public int getTestCaseLogRecordIndex(TestCaseLogRecord logRecord, ReportEntity reportEntity) {
        return LogRecordLookup.getInstance().getTestSuiteLogRecord(reportEntity).getChildIndex((ILogRecord)logRecord);
    }

    default public JiraIssueCollection getJiraIssueCollection(TestCaseLogRecord logRecord, ReportEntity reportEntity) {
        int index = this.getTestCaseLogRecordIndex(logRecord, reportEntity);
        return this.getJiraIssueCollection(index, logRecord, reportEntity);
    }

    default public void updateJiraReport(TestCaseLogRecord logRecord, JiraIssueCollection jiraIssueCollection, ReportEntity reportEntity) throws JiraIntegrationException {
        int index = this.getTestCaseLogRecordIndex(logRecord, reportEntity);
        this.updateJiraReport(index, logRecord, jiraIssueCollection, reportEntity);
    }
}

