/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.formatter;

import groovyjarjarantlr.Token;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.greclipse.GroovyTokenTypeBridge;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.core.utils.ASTTools;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.ASTNodeInfo;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.ASTScanner;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.predicates.IncludesClosureOrListPredicate;
import org.codehaus.groovy.eclipse.refactoring.core.utils.astScanner.predicates.SourceCodePredicate;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyBeautifier;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyIndentation;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyIndentationService;
import org.codehaus.groovy.eclipse.refactoring.formatter.IFormatterPreferences;
import org.codehaus.groovy.eclipse.refactoring.formatter.KlenkDocumentScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.UndoEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGroovyFormatter
extends GroovyFormatter {
    private static final boolean DEGUG = false;
    protected IFormatterPreferences pref;
    private ModuleNode rootNode;
    private Document formattedDocument;
    private final boolean indentOnly;
    public int formatOffset;
    public int formatLength;
    private KlenkDocumentScanner tokens;
    private int indentationLevel = 0;

    public DefaultGroovyFormatter(ITextSelection sel, IDocument doc, IFormatterPreferences pref, boolean indentOnly) {
        super(sel, doc);
        this.indentOnly = indentOnly;
        this.pref = pref;
        if (this.selection.getLength() != 0) {
            try {
                int startLine = this.document.getLineOfOffset(this.selection.getOffset());
                IRegion startLineInfo = this.document.getLineInformation(startLine);
                int endLine = this.document.getLineOfOffset(this.selection.getOffset() + this.selection.getLength() - 1);
                IRegion endLineInfo = this.document.getLineInformation(endLine);
                this.formatOffset = startLineInfo.getOffset();
                this.formatLength = endLineInfo.getOffset() + endLineInfo.getLength() - this.formatOffset;
            }
            catch (BadLocationException e) {
                GroovyCore.logException((String)"Exception when calculating offsets for formatting", (Throwable)e);
                this.formatOffset = this.selection.getOffset();
                this.formatLength = this.selection.getLength();
            }
        } else {
            this.formatOffset = 0;
            this.formatLength = this.document.getLength();
        }
    }

    public DefaultGroovyFormatter(IDocument doc, IFormatterPreferences prefs, int indentationLevel) {
        this((ITextSelection)new TextSelection(0, 0), doc, prefs, true);
        this.indentationLevel = indentationLevel;
    }

    private void initCodebase() throws Exception {
        GroovyCore.trace((String)this.formattedDocument.get());
        this.tokens = new KlenkDocumentScanner((IDocument)this.formattedDocument);
        this.rootNode = ASTTools.getASTNodeFromSource(this.formattedDocument.get());
        if (this.rootNode == null) {
            throw new Exception("Could not format.  Problem parsing Compilation unit.  Fix all syntax errors and try again.");
        }
    }

    @Override
    public TextEdit format() {
        this.formattedDocument = new Document(this.document.get());
        try {
            if (!this.indentOnly) {
                this.initCodebase();
                GroovyBeautifier beautifier = new GroovyBeautifier(this, this.pref);
                int lengthBefore = this.formattedDocument.getLength();
                beautifier.getBeautifiEdits().apply((IDocument)this.formattedDocument);
                int lengthAfter = this.formattedDocument.getLength();
                this.formatLength += lengthAfter - lengthBefore;
            }
            this.initCodebase();
            GroovyIndentation indent = new GroovyIndentation(this, this.pref, this.indentationLevel);
            UndoEdit undo2 = indent.getIndentationEdits().apply((IDocument)this.formattedDocument);
            this.formatLength += undo2.getLength();
        }
        catch (Exception e) {
            GroovyCore.logWarning((String)"Cannot format, probably due to compilation errors.  Please fix and try again.", (Throwable)e);
        }
        if (this.formattedDocument.get().equals(this.document.get())) {
            return new MultiTextEdit();
        }
        return new ReplaceEdit(0, this.document.getLength(), this.formattedDocument.get());
    }

    public boolean isMultilineStatement(Token t) {
        ASTNode node;
        if (t != null && this.isMultilineNodeType(node = this.findCorrespondingNode(t))) {
            IncludesClosureOrListPredicate cltest = new IncludesClosureOrListPredicate(false, t.getLine());
            node.visit((GroovyCodeVisitor)cltest);
            if (!((Boolean)cltest.getContainer()).booleanValue()) {
                String text = ASTTools.getTextofNode(node, (IDocument)this.formattedDocument);
                Matcher m = Pattern.compile(".*(\n|\r\n|\r).*", 32).matcher(this.trimEnd(text));
                return m.matches();
            }
        }
        return false;
    }

    public String trimEnd(String s) {
        int len = s.length();
        while (len > 0) {
            String w = s.substring(len - 1, len);
            if (!w.matches("\\s")) break;
            --len;
        }
        return s.substring(0, len);
    }

    private boolean isMultilineNodeType(ASTNode node) {
        if (node != null && node.getLineNumber() < node.getLastLineNumber()) {
            if (node instanceof ExpressionStatement) {
                return true;
            }
            if (node instanceof ReturnStatement) {
                return true;
            }
            if (node instanceof Statement) {
                return false;
            }
            if (node instanceof VariableExpression) {
                return false;
            }
            return !(node instanceof AnnotatedNode);
        }
        return false;
    }

    public ASTNode findCorrespondingNode(Token t) {
        ASTScanner scanner = new ASTScanner(this.rootNode, new SourceCodePredicate(t.getLine(), t.getColumn()), (IDocument)this.formattedDocument);
        scanner.startASTscan();
        Map.Entry<ASTNode, ASTNodeInfo> found = null;
        if (scanner.hasMatches()) {
            for (Map.Entry<ASTNode, ASTNodeInfo> e : scanner.getMatchedNodes().entrySet()) {
                if (found != null && ((ASTNodeInfo)found.getValue()).getLength() >= e.getValue().getLength()) continue;
                found = e;
            }
        }
        if (found != null) {
            return (ASTNode)found.getKey();
        }
        return null;
    }

    public ClosureExpression findCorrespondingClosure(Token t) {
        ASTScanner scanner = new ASTScanner(this.rootNode, new SourceCodePredicate(t.getLine(), t.getColumn()), (IDocument)this.formattedDocument);
        scanner.startASTscan();
        ClosureExpression found = null;
        if (scanner.hasMatches()) {
            for (Map.Entry<ASTNode, ASTNodeInfo> e : scanner.getMatchedNodes().entrySet()) {
                if (!(e.getKey() instanceof ClosureExpression)) continue;
                found = (ClosureExpression)e.getKey();
            }
        }
        return found;
    }

    public Token getTokenAfterParenthesis(int index) {
        int i = index;
        int countParenthesis = 1;
        while (this.tokens.get(i).getType() != GroovyTokenTypeBridge.LPAREN) {
            ++i;
        }
        ++i;
        while (countParenthesis > 0 && i < this.tokens.size() - 1) {
            int ttype = this.tokens.get(i).getType();
            if (ttype == GroovyTokenTypeBridge.LPAREN) {
                ++countParenthesis;
            } else if (ttype == GroovyTokenTypeBridge.RPAREN) {
                --countParenthesis;
            }
            ++i;
        }
        if (this.tokens.get(i).getType() == GroovyTokenTypeBridge.LCURLY || i >= this.tokens.size()) {
            return null;
        }
        return this.getNextToken(i);
    }

    public String getLeadingGap(int indent) {
        int spaces = indent * this.pref.getIndentationSize();
        return GroovyIndentationService.createIndentation(this.pref, spaces);
    }

    public String getNewLine() {
        return this.formattedDocument.getDefaultLineDelimiter();
    }

    public int getPositionOfNextToken(int cPos, boolean includingNLS) {
        int type;
        if (cPos == this.tokens.size() - 1) {
            return cPos;
        }
        int currentPos = cPos;
        while (((type = this.tokens.get(++currentPos).getType()) == GroovyTokenTypeBridge.WS || type == GroovyTokenTypeBridge.NLS && !includingNLS) && currentPos < this.tokens.size() - 2) {
        }
        return currentPos;
    }

    public Token getNextToken(int currentPos) {
        return this.tokens.get(this.getPositionOfNextToken(currentPos, false));
    }

    public Token getNextTokenIncludingNLS(int currentPos) {
        return this.tokens.get(this.getPositionOfNextToken(currentPos, true));
    }

    public int getPositionOfPreviousToken(int cPos, boolean includingNLS) {
        int type;
        int currentPos = cPos;
        while ((type = this.tokens.get(--currentPos).getType()) == GroovyTokenTypeBridge.NLS && !includingNLS && currentPos >= 0) {
        }
        return currentPos;
    }

    public Token getPreviousToken(int currentPos) {
        return this.tokens.get(this.getPositionOfPreviousToken(currentPos, false));
    }

    public Token getPreviousTokenIncludingNLS(int currentPos) {
        return this.tokens.get(this.getPositionOfPreviousToken(currentPos, true));
    }

    public int getOffsetOfToken(Token token) throws BadLocationException {
        return this.formattedDocument.getLineOffset(token.getLine() - 1) + token.getColumn() - 1;
    }

    public int getOffsetOfTokenEnd(Token token) throws BadLocationException {
        int offsetToken = this.getOffsetOfToken(token);
        int offsetNextToken = this.getOffsetOfToken(this.getNextTokenIncludingNLS(this.getPosOfToken(token)));
        String tokenWithGap = this.formattedDocument.get(offsetToken, offsetNextToken - offsetToken);
        return offsetToken + this.trimEnd(tokenWithGap).length();
    }

    public int getTokenLength(Token token) throws BadLocationException {
        return this.getOffsetOfTokenEnd(token) - this.getOffsetOfToken(token);
    }

    public Vector<Vector<Token>> getLineTokens() {
        return this.tokens.getLineTokensVector();
    }

    public int getPosOfToken(Token token) throws BadLocationException {
        return this.tokens.indexOf(token);
    }

    public int getPosOfToken(int tokenType, int line, int column, String tokenText) {
        int p = 0;
        while (p < this.tokens.size()) {
            Token a = this.tokens.get(p);
            if (a.getType() == tokenType && a.getColumn() == column && a.getLine() == line && a.getText().equals(tokenText)) {
                return p;
            }
            ++p;
        }
        return -1;
    }

    public int getPosOfToken(int lineNumber, int columnNumber) {
        int p = 0;
        while (p < this.tokens.size()) {
            Token a = this.tokens.get(p);
            if (a.getColumn() == columnNumber && a.getLine() == lineNumber) {
                return p;
            }
            ++p;
        }
        return -1;
    }

    public IDocument getProgressDocument() {
        return this.formattedDocument;
    }

    public ModuleNode getProgressRootNode() {
        return this.rootNode;
    }

    public KlenkDocumentScanner getTokens() {
        return this.tokens;
    }

    public void setIndentationLevel(int indentationLevel) {
        this.indentationLevel = indentationLevel;
    }

    public int getPosOfNextTokenOfType(int pClStart, int expectedType) {
        int type;
        int posClStart = pClStart;
        while ((type = this.tokens.get(++posClStart).getType()) != expectedType) {
        }
        return posClStart;
    }

    public int computeIndentLevel(String line) {
        int accumulatedSpaces = 0;
        int tabSize = this.pref.getTabSize();
        int currPos = 0;
        while (currPos < line.length()) {
            char c = line.charAt(currPos);
            if (c != ' ' && c != '\t') break;
            if (c == '\t') {
                accumulatedSpaces = this.nextTabStop(accumulatedSpaces, tabSize);
            } else if (c == ' ') {
                ++accumulatedSpaces;
            }
            ++currPos;
        }
        int indentSize = this.pref.getIndentationSize();
        return accumulatedSpaces / indentSize;
    }

    private int nextTabStop(int spaces, int tabSize) {
        int tabs = spaces / tabSize + 1;
        return tabs * tabSize;
    }
}

