/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.utils;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.text.edits.ReplaceEdit;

public class EditHelper {
    private EditHelper() {
    }

    public static ReplaceEdit getDefaultReplaceEdit(ASTNode node, boolean execute, IDocument document, String oldClassName, String newClassName) {
        TextSelection sel = new TextSelection(document, node.getStart(), node.getEnd() - node.getStart());
        int offset = sel.getOffset();
        if (execute) {
            return new ReplaceEdit(offset, oldClassName.length(), newClassName);
        }
        return new ReplaceEdit(offset, oldClassName.length(), oldClassName);
    }

    public static ReplaceEdit getLookupReplaceEdit(ASTNode node, boolean execute, IDocument document, String oldName, String newName) {
        TextSelection sel = new TextSelection(document, node.getStart(), node.getEnd() - node.getStart());
        int offset = sel.getOffset();
        if (execute) {
            if (node instanceof AnnotatedNode && ((AnnotatedNode)node).getNameEnd() > 0) {
                AnnotatedNode aNode = (AnnotatedNode)node;
                return new ReplaceEdit(aNode.getNameStart(), aNode.getNameEnd() - aNode.getNameStart() + 1, newName);
            }
            try {
                FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(document);
                IRegion foundRegion = finder.find(offset, oldName, true, true, true, false);
                IRegion lineInfoAtOffset = document.getLineInformationOfOffset(foundRegion.getOffset());
                String definitionLine = document.get(lineInfoAtOffset.getOffset(), lineInfoAtOffset.getLength());
                offset = lineInfoAtOffset.getOffset() + definitionLine.indexOf(oldName);
                if (definitionLine.indexOf(oldName) != definitionLine.lastIndexOf(oldName)) {
                    offset = lineInfoAtOffset.getOffset() + node.getColumnNumber() - 1;
                }
                return new ReplaceEdit(offset, oldName.length(), newName);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
        return new ReplaceEdit(offset, oldName.length(), oldName);
    }

    public static ReplaceEdit getRenameMethodCallEdit(MethodCallExpression node, IDocument document, String newName) {
        TextSelection sel = new TextSelection(document, node.getStart(), node.getEnd() - node.getStart());
        int offset = sel.getOffset();
        return new ReplaceEdit(offset += node.getMethod().getColumnNumber() - node.getColumnNumber(), node.getMethod().getText().length(), newName);
    }
}

