/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.rewriter;

import groovyjarjarasm.asm.Opcodes;
import java.util.List;
import org.codehaus.groovy.antlr.LineColumn;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.core.utils.FilePartReader;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class ASTWriterHelper
implements Opcodes {
    public static final int MOD_FIELD = 1;
    public static final int MOD_CLASS = 2;
    public static final int MOD_METHOD = 3;

    public static String getAccModifier(int modifiers, int appearance) {
        StringBuilder accMod = new StringBuilder();
        if ((modifiers & 2) != 0) {
            accMod.append("private ");
        } else if ((modifiers & 1) != 0) {
            if (appearance == 3) {
                accMod.append("def ");
            } else if (appearance == 1) {
                accMod.append("public ");
            }
        } else if ((modifiers & 4) != 0) {
            accMod.append("protected ");
        }
        if ((modifiers & 8) != 0) {
            accMod.append("static ");
        }
        if ((modifiers & 0x80) != 0) {
            accMod.append("transient ");
        }
        if ((modifiers & 0x10) != 0) {
            accMod.append("final ");
        }
        if ((modifiers & 0x20) != 0) {
            accMod.append("synchronized ");
        }
        if ((modifiers & 0x40) != 0) {
            accMod.append("volatile ");
        }
        if ((modifiers & 0x100) != 0) {
            accMod.append("native ");
        }
        if ((modifiers & 0x800) != 0) {
            accMod.append("strictfp ");
        }
        return accMod.toString();
    }

    public static boolean isProperty(FieldNode node) {
        List properties = node.getOwner().getProperties();
        for (PropertyNode property : properties) {
            if (!property.getField().equals(node)) continue;
            return true;
        }
        return false;
    }

    public static String getStringMarker(IDocument currentDocument, LineColumn coords) {
        String expressionInFile;
        if (currentDocument == null) {
            return "\"";
        }
        try {
            expressionInFile = FilePartReader.readForwardFromCoordinate(currentDocument, coords);
        }
        catch (BadLocationException e) {
            GroovyCore.logException((String)"Error during refactoring...trying to recover", (Throwable)e);
            expressionInFile = "";
        }
        char charBefore = expressionInFile.charAt(0);
        String firstThreeChars = "";
        boolean firstThreeCharsAreSame = false;
        if (expressionInFile.length() >= 3) {
            firstThreeChars = expressionInFile.substring(0, 3);
            boolean bl = firstThreeCharsAreSame = firstThreeChars.charAt(0) == firstThreeChars.charAt(1) && firstThreeChars.charAt(1) == firstThreeChars.charAt(2);
        }
        if (charBefore == '\'' || charBefore == '\"' || charBefore == '/') {
            if (firstThreeCharsAreSame) {
                return firstThreeChars;
            }
            return String.valueOf(charBefore);
        }
        return "\"";
    }
}

