/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.rename;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.search.ISearchRequestor;
import org.codehaus.groovy.eclipse.core.search.SyntheticAccessorSearchRequestor;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntheticAccessorsRenameParticipant
extends RenameParticipant {
    private IMember renameTarget;
    private List<SearchMatch> matches;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            this.matches = this.shouldUpdateReferences() ? this.findExtraReferences((IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (String)"Finding synthetic Groovy references", (int)10)) : Collections.emptyList();
            this.checkForBinaryRefs(this.matches, status);
            SearchResultGroup[] grouped = this.convert(this.matches);
            Checks.excludeCompilationUnits((SearchResultGroup[])grouped, (RefactoringStatus)status);
            status.merge(Checks.checkCompileErrorsInAffectedFiles((SearchResultGroup[])grouped));
            this.checkForPotentialRefs(this.matches, status);
        }
        catch (CoreException e) {
            GroovyCore.logException((String)e.getLocalizedMessage(), (Throwable)e);
            return RefactoringStatus.createFatalErrorStatus((String)e.getLocalizedMessage());
        }
        return status;
    }

    private boolean shouldUpdateReferences() {
        RefactoringProcessor processor = this.getProcessor();
        if (processor instanceof RenameFieldProcessor) {
            return ((RenameFieldProcessor)processor).getUpdateReferences();
        }
        if (processor instanceof RenameMethodProcessor) {
            return ((RenameMethodProcessor)processor).getUpdateReferences();
        }
        return true;
    }

    private void checkForPotentialRefs(List<SearchMatch> toCheck, RefactoringStatus status) {
        for (SearchMatch match : toCheck) {
            if (match.getAccuracy() != 1) continue;
            RefactoringStatusEntry entry = new RefactoringStatusEntry(2, RefactoringCoreMessages.RefactoringSearchEngine_potential_matches, JavaStatusContext.create((ITypeRoot)JavaCore.createCompilationUnitFrom((IFile)((IFile)match.getResource())), (ISourceRange)new SourceRange(match.getOffset(), match.getLength())));
            status.addEntry(entry);
        }
    }

    private void checkForBinaryRefs(List<SearchMatch> toCheck, RefactoringStatus status) throws JavaModelException {
        ReferencesInBinaryContext binaryRefs = new ReferencesInBinaryContext("Elements containing binary references to refactored element ''" + this.renameTarget.getElementName() + "''");
        Iterator<SearchMatch> iter = toCheck.iterator();
        while (iter.hasNext()) {
            SearchMatch match = iter.next();
            if (!this.isBinaryElement(match.getElement())) continue;
            if (match.getAccuracy() == 0) {
                binaryRefs.add(match);
            }
            iter.remove();
        }
        binaryRefs.addErrorIfNecessary(status);
    }

    private boolean isBinaryElement(Object element) throws JavaModelException {
        if (element instanceof IMember) {
            return ((IMember)element).isBinary();
        }
        if (element instanceof ICompilationUnit) {
            return true;
        }
        if (element instanceof IClassFile) {
            return false;
        }
        if (element instanceof IPackageFragment) {
            return this.isBinaryElement(((IPackageFragment)element).getParent());
        }
        if (element instanceof IPackageFragmentRoot) {
            return ((IPackageFragmentRoot)element).getKind() == 2;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private SearchResultGroup[] convert(List<SearchMatch> toGroup) {
        HashMap groups = new HashMap(toGroup.size());
        for (SearchMatch searchMatch : toGroup) {
            void var5_6;
            if (searchMatch.getResource() == null) continue;
            List list = (List)groups.get(searchMatch.getResource());
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                groups.put(searchMatch.getResource(), arrayList);
            }
            var5_6.add(searchMatch);
        }
        SearchResultGroup[] results = new SearchResultGroup[groups.size()];
        int i = 0;
        for (Map.Entry entry : groups.entrySet()) {
            results[i++] = new SearchResultGroup((IResource)entry.getKey(), ((List)entry.getValue()).toArray(new SearchMatch[0]));
        }
        return results;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(this.getName());
        this.createMatchedChanges(this.matches, change, this.getNameMap());
        if (change.getChildren().length > 0) {
            return change;
        }
        return null;
    }

    public String getName() {
        return "Rename Groovy synthetic getters and setters.";
    }

    protected boolean initialize(Object element) {
        if (element instanceof IMethod || element instanceof IField) {
            this.renameTarget = (IMember)element;
            if (!this.renameTarget.isReadOnly() && GroovyNature.hasGroovyNature((IProject)this.renameTarget.getJavaProject().getProject())) {
                return true;
            }
        }
        return false;
    }

    private String accessorName(String prefix, String name) {
        return String.valueOf(prefix) + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private void addChange(CompositeChange finalChange, IMember enclosingElement, int offset, int length, String newName) {
        CompilationUnitChange existingChange = this.findOrCreateChange(enclosingElement, finalChange);
        TextEditChangeGroup[] groups = existingChange.getTextEditChangeGroups();
        ReplaceEdit occurrenceEdit = new ReplaceEdit(offset, length, newName);
        boolean isOverlapping = false;
        TextEditChangeGroup[] textEditChangeGroupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            TextEditChangeGroup group = textEditChangeGroupArray[n2];
            if (group.getTextEdits()[0].covers((TextEdit)occurrenceEdit)) {
                isOverlapping = true;
                break;
            }
            ++n2;
        }
        if (isOverlapping) {
            return;
        }
        existingChange.addEdit((TextEdit)occurrenceEdit);
        existingChange.addChangeGroup((TextEditBasedChangeGroup)new TextEditChangeGroup((TextChange)existingChange, new TextEditGroup("Update synthetic Groovy accessor", (TextEdit)occurrenceEdit)));
    }

    private String basename(String fullName) {
        int baseStart = fullName.startsWith("is") && fullName.length() > 2 && Character.isUpperCase(fullName.charAt(2)) ? 2 : ((fullName.startsWith("get") || fullName.startsWith("set")) && fullName.length() > 3 && Character.isUpperCase(fullName.charAt(3)) ? 3 : -1);
        if (baseStart > 0) {
            return String.valueOf(Character.toLowerCase(fullName.charAt(baseStart))) + fullName.substring(baseStart + 1);
        }
        return fullName;
    }

    private void createMatchedChanges(List<SearchMatch> references, CompositeChange finalChange, Map<String, String> nameMap) throws JavaModelException {
        for (SearchMatch searchMatch : references) {
            String oldName;
            Object elt = searchMatch.getElement();
            if (!(elt instanceof IMember) || (oldName = this.findMatchName(searchMatch, nameMap.keySet())) == null) continue;
            String newName = nameMap.get(oldName);
            this.addChange(finalChange, (IMember)elt, searchMatch.getOffset(), oldName.length(), newName);
        }
    }

    private List<SearchMatch> findExtraReferences(IProgressMonitor pm) throws CoreException {
        SyntheticAccessorSearchRequestor synthRequestor = new SyntheticAccessorSearchRequestor();
        final ArrayList<SearchMatch> matches = new ArrayList<SearchMatch>();
        synthRequestor.findSyntheticMatches((IJavaElement)this.renameTarget, new ISearchRequestor(){

            public void acceptMatch(SearchMatch match) {
                matches.add(match);
            }
        }, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (String)"Find synthetic accessors", (int)10));
        return matches;
    }

    private String findMatchName(SearchMatch searchMatch, Set<String> keySet) throws JavaModelException {
        IJavaElement element = JavaCore.create((IResource)searchMatch.getResource());
        if (element.getElementType() == 5) {
            ICompilationUnit unit = (ICompilationUnit)element;
            String matchedText = unit.getBuffer().getText(searchMatch.getOffset(), searchMatch.getLength());
            for (String oldName : keySet) {
                if (!matchedText.startsWith(oldName)) continue;
                return oldName;
            }
        }
        return null;
    }

    private CompilationUnitChange findOrCreateChange(IMember accessor, CompositeChange finalChange) {
        TextChange textChange = this.getTextChange(accessor.getCompilationUnit());
        CompilationUnitChange existingChange = null;
        if (textChange instanceof CompilationUnitChange) {
            existingChange = (CompilationUnitChange)textChange;
        } else {
            Change[] children;
            Change[] changeArray = children = finalChange.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Change change = changeArray[n2];
                if (change instanceof CompilationUnitChange && ((CompilationUnitChange)change).getCompilationUnit().equals(accessor.getCompilationUnit())) {
                    existingChange = (CompilationUnitChange)change;
                    break;
                }
                ++n2;
            }
        }
        if (existingChange == null) {
            existingChange = new CompilationUnitChange("Synthetic Groovy Accessor changes for " + accessor.getCompilationUnit().getElementName(), accessor.getCompilationUnit());
            existingChange.setEdit((TextEdit)new MultiTextEdit());
            finalChange.add((Change)existingChange);
        }
        return existingChange;
    }

    private Map<String, String> getNameMap() {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        String newBaseName = this.basename(this.getArguments().getNewName());
        String oldBaseName = this.basename(this.renameTarget.getElementName());
        nameMap.put(oldBaseName, newBaseName);
        nameMap.put(this.accessorName("is", oldBaseName), this.accessorName("is", newBaseName));
        nameMap.put(this.accessorName("get", oldBaseName), this.accessorName("get", newBaseName));
        nameMap.put(this.accessorName("set", oldBaseName), this.accessorName("set", newBaseName));
        return nameMap;
    }
}

