/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.rename;

import java.util.HashMap;
import org.codehaus.groovy.eclipse.refactoring.core.rename.renameLocal.GroovyRenameLocalVariableProcessor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.ui.refactoring.UserInterfaceManager;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameLocalVariableWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameUserInterfaceManager;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameUserInterfaceStarter;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;

public class JavaRefactoringDispatcher {
    private IJavaElement element;
    private String newName;

    static {
        UserInterfaceManager uiManager = RenameUserInterfaceManager.getDefault();
        ReflectionUtils.executePrivateMethod(UserInterfaceManager.class, (String)"put", (Class[])new Class[]{Class.class, Class.class, Class.class}, (Object)uiManager, (Object[])new Object[]{GroovyRenameLocalVariableProcessor.class, RenameUserInterfaceStarter.class, RenameLocalVariableWizard.class});
    }

    public JavaRefactoringDispatcher(IJavaElement element) {
        this.element = element;
    }

    public RenameSupport dispatchJavaRenameRefactoring() throws CoreException {
        if (this.element instanceof IType) {
            return this.createTypeRefactoring((IType)this.element);
        }
        if (this.element instanceof IField) {
            return this.createFieldRefactoring((IField)this.element);
        }
        if (this.element instanceof IMethod) {
            return this.createMethodRefactoring((IMethod)this.element);
        }
        if (this.element instanceof ILocalVariable) {
            return this.createLocalVariableRefactoring();
        }
        return null;
    }

    private RenameSupport createLocalVariableRefactoring() throws CoreException {
        RenameJavaElementDescriptor descriptor = this.createDescriptorForLocalVariable();
        return RenameSupport.create((RenameJavaElementDescriptor)descriptor);
    }

    public RenameJavaElementDescriptor createDescriptorForLocalVariable() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("name", this.getNewName());
        args.put("input", this.element.getHandleIdentifier());
        RenameJavaElementDescriptor descriptor = new RenameJavaElementDescriptor("org.eclipse.jdt.ui.rename.local.variable", this.element.getJavaProject().getElementName(), "Rename " + this.element.getElementName(), null, args, 1);
        ReflectionUtils.setPrivateField(RefactoringDescriptor.class, (String)"fRefactoringId", (Object)descriptor, (Object)"org.codehaus.groovy.eclipse.refactoring.renameLocal");
        return descriptor;
    }

    private RenameSupport createTypeRefactoring(IType type) throws CoreException {
        return RenameSupport.create((IType)type, (String)this.getNewName(), (int)65);
    }

    private RenameSupport createFieldRefactoring(IField field) throws CoreException {
        return RenameSupport.create((IField)field, (String)this.getNewName(), (int)113);
    }

    private RenameSupport createMethodRefactoring(IMethod method) throws CoreException {
        return RenameSupport.create((IMethod)method, (String)this.getNewName(), (int)1);
    }

    public String getNewName() {
        if (this.newName != null) {
            return this.newName;
        }
        return this.element.getElementName();
    }

    public void setNewName(String name) {
        this.newName = name;
    }
}

