/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.rename;

import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class ForcePreviewParticipant
extends RenameParticipant {
    private static boolean muted = false;
    private static final String FIRST_MSG = "This is a rename refactoring involving Groovy.\nDue to Groovy's dynamicism, it is recommended that\nyou preview the changes before applying them.";
    private static final String SECOND_MSG = "If you do not want to rename the associated file, UNCHECK\nthe 'Move Compilation Unit' option in the preview pane.";
    private IType type;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = RefactoringStatus.createWarningStatus((String)FIRST_MSG);
        if (this.shouldWarnAboutFileRename()) {
            status.addWarning(SECOND_MSG);
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public String getName() {
        return "Force preview when performing Groovy changes";
    }

    protected boolean initialize(Object element) {
        if (muted) {
            return false;
        }
        if (element instanceof IMember || element instanceof ILocalVariable) {
            IJavaElement member = (IJavaElement)element;
            boolean groovyElement = member.getAncestor(5) instanceof GroovyCompilationUnit;
            if (groovyElement && element instanceof IType) {
                this.type = (IType)element;
            }
            return groovyElement;
        }
        return false;
    }

    boolean shouldWarnAboutFileRename() {
        if (this.type != null) {
            return this.type.equals(this.type.getCompilationUnit().findPrimaryType());
        }
        return false;
    }

    public static void mute() {
        muted = true;
    }

    public static void unmute() {
        muted = false;
    }
}

