/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.updater.utils;

import com.kms.katalon.updater.Updater;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LogUtils {
    private static Logger logger;

    public static Logger getLogger() {
        if (logger != null) {
            return logger;
        }
        logger = Logger.getLogger("Katalon Studio Updater");
        try {
            CodeSource codeSource = Updater.class.getProtectionDomain().getCodeSource();
            File jarFile = new File(codeSource.getLocation().toURI().getPath());
            String jarDir = jarFile.getParentFile().getPath();
            String logFilePath = new File(jarDir, "update.log").getAbsolutePath();
            FileHandler handler = new FileHandler(logFilePath, true);
            handler.setFormatter(new SimpleFormatter(){
                private final String format = "%1$tY-%1$tm-%1$td %1$tI:%1$tM:%1$tS %1$Tp %2$s%4$s: %5$s%6$s%n";
                private final Date dat = new Date();

                @Override
                public synchronized String format(LogRecord record) {
                    this.dat.setTime(record.getMillis());
                    String message = this.formatMessage(record);
                    String throwable = "";
                    if (record.getThrown() != null) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        pw.println();
                        record.getThrown().printStackTrace(pw);
                        pw.close();
                        throwable = sw.toString();
                    }
                    return String.format("%1$tY-%1$tm-%1$td %1$tI:%1$tM:%1$tS %1$Tp %2$s%4$s: %5$s%6$s%n", this.dat, "", "", record.getLevel().getLocalizedName(), message, throwable);
                }
            });
            logger.addHandler(handler);
        }
        catch (IOException iOException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return logger;
    }
}

