/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.updater.download;

import com.kms.katalon.updater.UpdateException;
import com.kms.katalon.updater.models.FileInfo;
import com.kms.katalon.updater.utils.LogUtils;
import com.kms.katalon.updater.utils.PathUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class FileExtractor {
    private final File extractDir;
    private final FileInfo fileInfo;
    private final String appDir;
    private Logger logger = LogUtils.getLogger();

    public FileExtractor(FileInfo fileInfo, String appDir, File extractDir) {
        this.fileInfo = fileInfo;
        this.appDir = appDir;
        this.extractDir = extractDir;
    }

    public void extract() throws UpdateException {
        this.extractDir.mkdirs();
        try {
            File extractedFolder = new File(this.extractDir, this.fileInfo.getLocation().replace(".tar.gz", ""));
            File destDir = new File(this.appDir, this.fileInfo.getExtractLocation());
            this.cleanOldVersionFiles(destDir);
            this.logger.info(MessageFormat.format("Copying extracted resources from {0} to {1}", extractedFolder.getAbsolutePath(), destDir.getAbsolutePath()));
            FileUtils.copyDirectory(extractedFolder, destDir);
            Arrays.asList(this.fileInfo.getExecutableFiles()).stream().forEach(path -> new File(this.appDir, (String)path).setExecutable(true));
        }
        catch (IOException e) {
            throw new UpdateException(e);
        }
    }

    private void cleanOldVersionFiles(File destDir) throws IOException {
        final LinkedList removedFiles = new LinkedList();
        Files.walkFileTree(Paths.get(destDir.toURI()), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                File file = path.toFile();
                if (!FileExtractor.this.isFileUnderExcluded(file)) {
                    removedFiles.add(file);
                } else {
                    FileExtractor.this.logger.info(MessageFormat.format("File {0} is excluded with {1}", FileExtractor.this.getRelativePath(file), FileExtractor.this.fileInfo.getLocation()));
                }
                return super.visitFile(path, attrs);
            }
        });
        Iterator removeFilesIterator = removedFiles.iterator();
        while (removeFilesIterator.hasNext()) {
            FileUtils.deleteQuietly((File)removeFilesIterator.next());
        }
    }

    private boolean isFileUnderExcluded(File file) {
        List<String> excludes = Arrays.asList(this.fileInfo.getExcludes());
        String relativePath = this.getRelativePath(file);
        if (file.isFile()) {
            return excludes.stream().filter(path -> relativePath.startsWith((String)path)).count() > 0L;
        }
        return true;
    }

    private String getRelativePath(File file) {
        String relativePath = PathUtils.absoluteToRelativePath(file.getAbsolutePath(), this.appDir);
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.replaceFirst("/", "");
        }
        return relativePath;
    }
}

