/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.global.support;

import com.kms.katalon.composer.global.editor.GlobalVariableSelectionCellEditor;
import com.kms.katalon.composer.global.provider.TableViewerProvider;
import com.kms.katalon.entity.global.GlobalVariableEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;

public class GlobalVariableEdittingSupport
extends EditingSupport {
    private TableViewerProvider provider;
    private GlobalVariableEntity edittedVariable;

    public GlobalVariableEdittingSupport(TableViewerProvider provider) {
        super((ColumnViewer)provider.getTableViewer());
        this.provider = provider;
    }

    protected CellEditor getCellEditor(Object element) {
        if (!(element instanceof GlobalVariableEntity)) {
            return null;
        }
        return new GlobalVariableSelectionCellEditor((Composite)this.getViewer().getControl(), (GlobalVariableEntity)element, this.getAllGlobalVariableName());
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        if (element instanceof GlobalVariableEntity) {
            return (GlobalVariableEntity)element;
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (!(value instanceof GlobalVariableEntity)) {
            return;
        }
        this.edittedVariable = (GlobalVariableEntity)value;
        this.provider.performOperation(new EditVariableOperation());
    }

    private List<String> getAllGlobalVariableName() {
        TableViewer tableViewer = this.provider.getTableViewer();
        if (tableViewer == null || tableViewer.getTable().isDisposed()) {
            return Collections.emptyList();
        }
        ArrayList<String> varNames = new ArrayList<String>();
        TableItem[] tableItemArray = tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            varNames.add(((GlobalVariableEntity)item.getData()).getName());
            ++n2;
        }
        return varNames;
    }

    private class EditVariableOperation
    extends AbstractOperation {
        private GlobalVariableEntity oldVariable;
        private GlobalVariableEntity variable;
        private GlobalVariableEntity newVariable;
        private boolean isNameChanged;

        public EditVariableOperation() {
            super(EditVariableOperation.class.getName());
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            boolean isChanged;
            this.variable = (GlobalVariableEntity)((StructuredSelection)GlobalVariableEdittingSupport.this.provider.getTableViewer().getSelection()).getFirstElement();
            this.newVariable = GlobalVariableEdittingSupport.this.edittedVariable;
            boolean bl = isChanged = !this.variable.getDescription().equals(this.newVariable.getDescription()) || !this.variable.getInitValue().equals(this.newVariable.getInitValue()) || !this.variable.getName().equals(this.newVariable.getName());
            if (!isChanged) {
                return Status.CANCEL_STATUS;
            }
            this.oldVariable = this.variable.clone();
            this.isNameChanged = !this.variable.getName().equals(this.newVariable.getName());
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.isNameChanged) {
                GlobalVariableEdittingSupport.this.provider.getNeedToUpdateVariables().put(this.variable, this.oldVariable.getName());
            }
            this.doEditVariable(this.newVariable);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.isNameChanged) {
                Map<GlobalVariableEntity, String> needToUpdateVariables = GlobalVariableEdittingSupport.this.provider.getNeedToUpdateVariables();
                if (needToUpdateVariables.containsKey(this.variable)) {
                    needToUpdateVariables.remove(this.variable);
                } else {
                    needToUpdateVariables.put(this.variable, this.newVariable.getName());
                }
            }
            this.doEditVariable(this.oldVariable);
            return Status.OK_STATUS;
        }

        private void doEditVariable(GlobalVariableEntity changedVariable) {
            this.variable.setDescription(changedVariable.getDescription());
            this.variable.setInitValue(changedVariable.getInitValue());
            this.variable.setName(changedVariable.getName());
            GlobalVariableEdittingSupport.this.getViewer().refresh((Object)this.variable);
            GlobalVariableEdittingSupport.this.provider.markDirty();
        }
    }
}

