/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.folder.handlers;

import com.kms.katalon.composer.components.dialogs.CWizardDialog;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.wizard.RenameWizard;
import com.kms.katalon.composer.folder.constants.StringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameFolderHandler {
    @Inject
    IEventBroker eventBroker;
    @Inject
    EPartService partService;
    @Named(value="activeShell")
    Shell parentShell;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof FolderTreeEntity) {
                    RenameFolderHandler.this.execute((FolderTreeEntity)object);
                }
            }
        });
    }

    private void execute(FolderTreeEntity folderTreeEntity) {
        block16: {
            try {
                RenameWizard renameWizard;
                CWizardDialog wizardDialog;
                int code;
                FolderEntity oldFolder = folderTreeEntity.getObject();
                if (oldFolder == null || (code = (wizardDialog = new CWizardDialog(this.parentShell, (IWizard)(renameWizard = new RenameWizard((ITreeEntity)folderTreeEntity, FolderController.getInstance().getChildrenNames(oldFolder.getParentFolder()))))).open()) != 0) break block16;
                FolderEntity folder = folderTreeEntity.getObject();
                String oldName = folder.getName();
                try {
                    if (renameWizard.getNewNameValue() != null && !renameWizard.getNewNameValue().equals("") && !renameWizard.getNewNameValue().equalsIgnoreCase(oldName)) {
                        ArrayList<FileEntity> allDescendantEntites = new ArrayList<FileEntity>();
                        for (Object descendantEntity : FolderController.getInstance().getAllDescentdantEntities(folder)) {
                            if (descendantEntity instanceof FolderEntity) continue;
                            allDescendantEntites.add((FileEntity)descendantEntity);
                        }
                        String folderParentPath = String.valueOf(folder.getParentFolder().getRelativePathForUI().replace('\\', '/')) + '/';
                        FolderController.getInstance().updateFolderName(folder, renameWizard.getNewNameValue());
                        this.eventBroker.post("EXPLORER/RENAMED_SELECTED_ITEM", (Object)new Object[]{String.valueOf(folderParentPath) + oldName + '/', String.valueOf(folderParentPath) + renameWizard.getNewNameValue() + '/'});
                        folder.setName(renameWizard.getNewNameValue());
                        String eventTopic = null;
                        switch (folder.getFolderType()) {
                            case TESTCASE: {
                                eventTopic = "TESTCASE/UPDATED";
                                break;
                            }
                            case DATAFILE: {
                                eventTopic = "TESTDATA/UPDATE";
                                break;
                            }
                            case TESTSUITE: {
                                eventTopic = "TESTSUITE/UPDATED";
                                break;
                            }
                            case WEBELEMENT: {
                                eventTopic = "TESTOBJECT/UPDATED";
                                break;
                            }
                            case CHECKPOINT: {
                                eventTopic = "CHECKPOINT/UPDATED";
                                break;
                            }
                        }
                        if (eventTopic != null) {
                            for (FileEntity entity : allDescendantEntites) {
                                this.eventBroker.post(eventTopic, (Object)new Object[]{entity.getId(), entity});
                            }
                        }
                        if (folderTreeEntity.getParent() != null) {
                            this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)folderTreeEntity.getParent());
                            this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)folderTreeEntity);
                        }
                        this.partService.saveAll(false);
                    }
                }
                catch (Exception ex) {
                    folder.setName(oldName);
                    LoggerSingleton.getInstance().getLogger().error((Throwable)ex);
                    MessageDialog.openError((Shell)this.parentShell, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_RENAME_FOLDER);
                }
            }
            catch (Exception e) {
                LoggerSingleton.getInstance().getLogger().error((Throwable)e);
            }
        }
    }
}

