/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.folder.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.ReportTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.handlers.deletion.AbstractDeleteReferredEntityHandler;
import com.kms.katalon.composer.explorer.handlers.deletion.IDeleteEntityHandler;
import com.kms.katalon.composer.folder.constants.StringConstants;
import com.kms.katalon.composer.folder.handlers.deletion.DeleteFolderHandlerFactory;
import com.kms.katalon.composer.folder.handlers.deletion.IDeleteFolderHandler;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.entity.dal.exception.EntityIsReferencedException;
import com.kms.katalon.entity.dal.exception.TestCaseIsReferencedByTestSuiteExepception;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DeleteFolderHandler
implements IDeleteEntityHandler {
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    MApplication application;

    private List<String> getChildrenId(FolderTreeEntity folderTreeEntity) throws Exception {
        ArrayList<String> childEntitiesPartId = new ArrayList<String>();
        Object[] objectArray = folderTreeEntity.getChildren();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof FolderTreeEntity) {
                childEntitiesPartId.addAll(this.getChildrenId((FolderTreeEntity)child));
            } else {
                String partId = null;
                if (child instanceof TestCaseTreeEntity) {
                    partId = EntityPartUtil.getTestCaseCompositePartId((String)((TestCaseTreeEntity)child).getObject().getId());
                } else if (child instanceof TestSuiteTreeEntity) {
                    partId = EntityPartUtil.getTestSuiteCompositePartId((String)((TestSuiteTreeEntity)child).getObject().getId());
                } else if (child instanceof WebElementTreeEntity) {
                    partId = EntityPartUtil.getTestObjectPartId((String)((WebElementEntity)((WebElementTreeEntity)child).getObject()).getId());
                } else if (child instanceof TestDataTreeEntity) {
                    partId = EntityPartUtil.getTestDataPartId((String)((TestDataTreeEntity)child).getObject().getId());
                } else if (child instanceof ReportTreeEntity) {
                    partId = EntityPartUtil.getReportPartId((String)((ReportTreeEntity)child).getObject().getId());
                }
                if (partId != null) {
                    childEntitiesPartId.add(partId);
                }
            }
            ++n2;
        }
        return childEntitiesPartId;
    }

    private void removeFromExplorer(List<String> childrenEntityId) throws Exception {
        for (String childId : childrenEntityId) {
            if (childId == null) continue;
            MPartStack mStackPart = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
            MPart mPart = (MPart)this.modelService.find(childId, (MUIElement)this.application);
            if (mPart == null) continue;
            mStackPart.getChildren().remove(mPart);
        }
    }

    public Class<? extends ITreeEntity> entityType() {
        return FolderTreeEntity.class;
    }

    public boolean execute(ITreeEntity entity, IProgressMonitor monitor) {
        block7: {
            if (entity instanceof FolderTreeEntity && entity.getObject() instanceof FolderEntity) break block7;
            return false;
        }
        try {
            List<String> childEntitiesPartId = this.getChildrenId((FolderTreeEntity)entity);
            FolderEntity folderEntity = (FolderEntity)entity.getObject();
            boolean showYesNoToAllOptions = childEntitiesPartId.size() > 1;
            IDeleteFolderHandler handler = DeleteFolderHandlerFactory.getInstance().getDeleteHandler(folderEntity.getFolderType());
            if (handler != null) {
                if (handler instanceof AbstractDeleteReferredEntityHandler) {
                    ((AbstractDeleteReferredEntityHandler)handler).setNeedYesNoToAllButtons(showYesNoToAllOptions);
                }
                handler.execute((FolderTreeEntity)entity, monitor);
            } else {
                FolderController.getInstance().deleteFolder(folderEntity);
                this.removeFromExplorer(childEntitiesPartId);
            }
            this.eventBroker.post("EXPLORER/DELETED_SELECTED_ITEM", (Object)(String.valueOf(folderEntity.getIdForDisplay()) + '/'));
            return true;
        }
        catch (EntityIsReferencedException | TestCaseIsReferencedByTestSuiteExepception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_DELETE_FOLDER);
        }
        return false;
    }
}

