/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.preference;

import com.kms.katalon.composer.components.dialogs.FieldEditorPreferencePageWithHelp;
import com.kms.katalon.composer.integration.git.constants.GitStringConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;

public class GitPreferencePage
extends FieldEditorPreferencePageWithHelp {
    private Composite remoteTimeoutParentComposite;
    private IntegerFieldEditor remoteTimeoutFieldEditor;
    private BooleanFieldEditor gitEnableFieldEditor;

    public GitPreferencePage() {
        this.setPreferenceStore((IPreferenceStore)PreferenceStoreManager.getPreferenceStore(GitPreferencePage.class));
    }

    protected void createFieldEditors() {
        this.gitEnableFieldEditor = new BooleanFieldEditor("git.enable", GitStringConstants.ENABLE_GIT_CHECK_LABEL, this.getFieldEditorParent());
        this.addField((FieldEditor)this.gitEnableFieldEditor);
        this.remoteTimeoutParentComposite = this.getFieldEditorParent();
        this.remoteTimeoutFieldEditor = new IntegerFieldEditor("remote_connection_timeout", UIText.RemoteConnectionPreferencePage_TimeoutLabel, this.remoteTimeoutParentComposite);
        this.addField((FieldEditor)this.remoteTimeoutFieldEditor);
    }

    protected void initialize() {
        super.initialize();
        this.enableEditors(this.gitEnableFieldEditor.getBooleanValue());
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.gitEnableFieldEditor) {
            this.enableEditors(this.gitEnableFieldEditor.getBooleanValue());
        }
        super.propertyChange(event);
    }

    private void enableEditors(boolean isEnable) {
        this.remoteTimeoutFieldEditor.setEnabled(isEnable, this.remoteTimeoutParentComposite);
    }

    public boolean performOk() {
        if (this.gitEnableFieldEditor == null) {
            return super.performOk();
        }
        if (this.gitEnableFieldEditor.getBooleanValue()) {
            GitProjectData.attachToWorkspace();
        } else {
            GitProjectData.detachFromWorkspace();
        }
        if (this.remoteTimeoutFieldEditor != null) {
            Activator.getDefault().getPreferenceStore().setValue("remote_connection_timeout", this.remoteTimeoutFieldEditor.getIntValue());
        }
        return super.performOk();
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.PREFERENCE_GIT;
    }
}

