/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.handlers;

import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.editors.MarkdownPart;
import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.composer.components.services.PartServiceSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.integration.git.constants.GitStringConstants;
import com.kms.katalon.composer.integration.git.handlers.ShareProjectHandler;
import com.kms.katalon.composer.project.dialog.ProjectChoosingDialog;
import com.kms.katalon.composer.project.handlers.NewProjectHandler;
import com.kms.katalon.composer.project.handlers.OpenProjectHandler;
import com.kms.katalon.composer.project.sample.SampleRemoteProject;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class CloneRemoteProjectHandler {
    private static final int FETCH_TIMEOUT_IN_MILLIS = 15000;
    private static final String MARKDOWN_PART_URI = "bundleclass://" + FrameworkUtil.getBundle(MarkdownPart.class).getSymbolicName() + "/" + MarkdownPart.class.getName();
    private boolean shouldHandleProjectOpenAfterClone = false;
    private File destinationFolder = null;
    private ProjectType projectType;
    private SampleRemoteProject sample;
    @Inject
    EPartService partService;
    @Inject
    EModelService modelService;
    @Inject
    MApplication application;

    @PostConstruct
    public void registerEventHandler() {
        EventBrokerSingleton.getInstance().getEventBroker().subscribe("GIT/CLONE_REMOTE_PROJECT", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                Object[] objects = this.getObjects(event);
                CloneRemoteProjectHandler.this.sample = (SampleRemoteProject)objects[0];
                String projectLocation = ((ProjectEntity)objects[1]).getLocation();
                CloneRemoteProjectHandler.this.projectType = ((ProjectEntity)objects[1]).getType();
                final File workdir = new File(projectLocation);
                workdir.mkdirs();
                Job job = new Job("Cloning remote project"){

                    /*
                     * Loose catch block
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            Collection refs;
                            URIish uri;
                            block19: {
                                monitor.beginTask("Cloning remote project...", 100);
                                uri = new URIish(CloneRemoteProjectHandler.this.sample.getSourceUrl());
                                Repository db = FileRepositoryBuilder.create((File)new File("/tmp"));
                                refs = new ArrayList();
                                Throwable throwable = null;
                                Object var6_7 = null;
                                Git git = new Git(db);
                                LsRemoteCommand rc = git.lsRemote();
                                rc.setRemote(uri.toString()).setTimeout(15000);
                                try {
                                    refs = rc.call();
                                }
                                catch (GitAPIException gitAPIException) {
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    if (git != null) {
                                        git.close();
                                    }
                                    monitor.done();
                                    return iStatus;
                                }
                                try {
                                    if (git != null) {
                                        git.close();
                                    }
                                    break block19;
                                    {
                                        catch (Throwable throwable2) {
                                            if (git != null) {
                                                git.close();
                                            }
                                            throw throwable2;
                                        }
                                    }
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    throw throwable;
                                }
                            }
                            monitor.worked(30);
                            CloneOperation cloneOp = new CloneOperation(uri, false, refs, workdir, CloneRemoteProjectHandler.this.sample.getDefaultBranch(), "origin", 15000);
                            cloneOp.run(monitor);
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        catch (IOException | InterruptedException | InvocationTargetException | URISyntaxException exception) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                job.setUser(true);
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        CloneRemoteProjectHandler.this.destinationFolder = workdir;
                        Thread thread = new Thread(() -> {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            UISynchronizeService.syncExec(() -> CloneRemoteProjectHandler.this.openOrCreateNewProjectAtDestination());
                        });
                        thread.start();
                    }
                });
                job.schedule();
            }
        });
    }

    @Inject
    @Optional
    private void gitCloneSuccessEventHandler(@UIEventTopic(value="PROJECT/OPENED") Object object) throws InvocationTargetException, InterruptedException {
        if (!this.shouldHandleProjectOpenAfterClone) {
            return;
        }
        this.openReadme(this.destinationFolder);
        this.shouldHandleProjectOpenAfterClone = false;
        this.destinationFolder = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void openOrCreateNewProjectAtDestination() {
        File projectFile = OpenProjectHandler.getProjectFile((File)this.destinationFolder);
        if (projectFile == null) {
            List nestedProjectFiles = OpenProjectHandler.getProjectFiles((File)this.destinationFolder);
            if (nestedProjectFiles.size() > 0) {
                ProjectChoosingDialog dialog = new ProjectChoosingDialog(Display.getCurrent().getActiveShell(), this.destinationFolder, nestedProjectFiles);
                if (dialog.open() != 0) return;
                projectFile = dialog.getSelectedProjectFile();
            } else {
                try {
                    this.shouldHandleProjectOpenAfterClone = true;
                    ProjectEntity newProject = NewProjectHandler.createNewProject((String)this.destinationFolder.getName(), (String)this.destinationFolder.getParentFile().getAbsolutePath(), (String)"");
                    ShareProjectHandler.addDefaultIgnores(newProject.getFolderLocation());
                    projectFile = new File(newProject.getLocation());
                    EventBrokerSingleton.getInstance().getEventBroker().send("PROJECT/CREATED", (Object)newProject);
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GitStringConstants.ERROR, (String)GitStringConstants.HAND_ERROR_MSG_UNABLE_TO_CLONE);
                    return;
                }
            }
        }
        try {
            this.shouldHandleProjectOpenAfterClone = true;
            ProjectEntity project = this.updateProject(projectFile);
            Trackings.trackCreatingSampleProject((String)this.sample.getName(), (String)project.getUUID(), (ProjectType)this.projectType);
            EventBrokerSingleton.getInstance().getEventBroker().send("PROJECT/CREATED", (Object)project);
            OpenProjectHandler.doOpenProject(null, (String)projectFile.getAbsolutePath(), (UISynchronize)UISynchronizeService.getInstance().getSync(), (IEventBroker)EventBrokerSingleton.getInstance().getEventBroker(), (EPartService)PartServiceSingleton.getInstance().getPartService(), (EModelService)ModelServiceSingleton.getInstance().getModelService(), (MApplication)ApplicationSingleton.getInstance().getApplication());
            TimeUnit.SECONDS.sleep(1L);
            if (this.projectType == ProjectType.WEBSERVICE) {
                EventBrokerSingleton.getInstance().getEventBroker().post("API/OPEN_QUICK_START_DIALOG", null);
            }
            if (this.projectType == ProjectType.WEBUI) {
                EventBrokerSingleton.getInstance().getEventBroker().post("API/OPEN_QUICK_START_WEB_DIALOG", null);
            }
            if (this.projectType != ProjectType.MOBILE) return;
            EventBrokerSingleton.getInstance().getEventBroker().post("API/OPEN_QUICK_START_MOBILE_DIALOG", null);
            return;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GitStringConstants.ERROR, (String)GitStringConstants.HAND_ERROR_MSG_UNABLE_TO_CLONE);
        }
    }

    private ProjectEntity updateProject(File projectFile) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getProject(projectFile.getAbsolutePath());
        project.setUUID(Util.generateGuid());
        project.setType(this.projectType);
        project.setFolderLocation(this.destinationFolder.getAbsolutePath());
        ProjectController.getInstance().updateProject(project);
        return project;
    }

    public void openReadme(File repoLocation) {
        File readme = new File(repoLocation, "README.md");
        if (!readme.exists()) {
            return;
        }
        MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        String partId = readme.getAbsolutePath();
        MPart mPart = (MPart)this.modelService.find(partId, (MUIElement)this.application);
        mPart = (MPart)this.modelService.createModelElement(MPart.class);
        mPart.setElementId(partId);
        mPart.setLabel(readme.getName());
        mPart.setIconURI(ImageManager.getImageURLString((String)"entity/txt_test_object_16.png"));
        mPart.setContributionURI(MARKDOWN_PART_URI);
        mPart.setTooltip(readme.getAbsolutePath());
        mPart.setCloseable(true);
        stack.getChildren().add(mPart);
        if (mPart.getObject() == null) {
            mPart.setObject((Object)readme);
        }
        this.partService.showPart(mPart, EPartService.PartState.ACTIVATE);
        stack.setSelectedElement((MUIElement)mPart);
    }
}

