/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.handlers;

import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.composer.components.services.PartServiceSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.integration.git.components.wizards.CustomGitCloneWizard;
import com.kms.katalon.composer.integration.git.constants.GitStringConstants;
import com.kms.katalon.composer.integration.git.handlers.ShareProjectHandler;
import com.kms.katalon.composer.project.handlers.NewProjectHandler;
import com.kms.katalon.composer.project.handlers.OpenProjectHandler;
import com.kms.katalon.entity.project.ProjectEntity;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CloneHandler {
    @Inject
    private IEclipseContext context;

    @CanExecute
    public boolean canExecute() {
        return true;
    }

    @Execute
    public void execute(Shell parentShell) {
        WizardDialog dlg = new WizardDialog(parentShell, (IWizard)new CustomGitCloneWizard());
        dlg.open();
    }

    @Inject
    @Optional
    private void gitCloneSuccessEventHandler(@UIEventTopic(value="GIT/CLONE_FINISHED") File destination) throws InvocationTargetException, InterruptedException {
        CloneHandler.openOrCreateNewProjectAtDestination(destination);
    }

    private static void openOrCreateNewProjectAtDestination(File destinationFolder) {
        File projectFile = OpenProjectHandler.getProjectFile((File)destinationFolder);
        if (projectFile == null) {
            try {
                ProjectEntity newProject = NewProjectHandler.createNewProject((String)destinationFolder.getName(), (String)destinationFolder.getParentFile().getAbsolutePath(), (String)"");
                ShareProjectHandler.addDefaultIgnores(newProject.getFolderLocation());
                projectFile = new File(newProject.getLocation());
                EventBrokerSingleton.getInstance().getEventBroker().send("PROJECT/CREATED", (Object)newProject);
            }
            catch (Exception e) {
                LoggerSingleton.getInstance().getLogger().error((Throwable)e);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GitStringConstants.ERROR, (String)GitStringConstants.HAND_ERROR_MSG_UNABLE_TO_CLONE);
                return;
            }
        }
        try {
            OpenProjectHandler.doOpenProject(null, (String)projectFile.getAbsolutePath(), (UISynchronize)UISynchronizeService.getInstance().getSync(), (IEventBroker)EventBrokerSingleton.getInstance().getEventBroker(), (EPartService)PartServiceSingleton.getInstance().getPartService(), (EModelService)ModelServiceSingleton.getInstance().getModelService(), (MApplication)ApplicationSingleton.getInstance().getApplication());
        }
        catch (Exception e) {
            LoggerSingleton.getInstance().getLogger().error((Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GitStringConstants.ERROR, (String)GitStringConstants.HAND_ERROR_MSG_UNABLE_TO_CLONE);
        }
    }
}

