/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.components.wizards;

import com.kms.katalon.composer.integration.git.components.wizards.CustomRepositorySelectionPage;
import com.kms.katalon.composer.integration.git.internal.push.CustomConfirmationPage;
import com.kms.katalon.composer.integration.git.internal.push.CustomPushResultDialog;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.PushOperation;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RefSpecPage;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class CustomPushWizard
extends Wizard {
    private static final String HELP_CONTEXT = "org.eclipse.egit.ui.PushWizard";
    private Repository localDb;
    private final CustomRepositorySelectionPage repoPage;
    private final RefSpecPage refSpecPage;
    private CustomConfirmationPage confirmPage;

    public CustomPushWizard(Repository localDb) throws URISyntaxException {
        this.localDb = localDb;
        this.repoPage = new CustomRepositorySelectionPage(false, RemoteConfig.getAllRemoteConfigs((Config)localDb.getConfig()), null);
        this.refSpecPage = new RefSpecPage(localDb, true){

            public void setVisible(boolean visible) {
                if (visible) {
                    this.setSelection(CustomPushWizard.this.repoPage.getSelection());
                    this.setCredentials(CustomPushWizard.this.repoPage.getCredentials());
                }
                super.setVisible(visible);
            }
        };
        this.refSpecPage.setHelpContext(HELP_CONTEXT);
        this.confirmPage = new CustomConfirmationPage(localDb){

            public void setVisible(boolean visible) {
                if (visible) {
                    this.setSelection(CustomPushWizard.this.repoPage.getSelection(), CustomPushWizard.this.refSpecPage.getRefSpecs());
                    this.setCredentials(CustomPushWizard.this.repoPage.getCredentials());
                }
                super.setVisible(visible);
            }
        };
        this.confirmPage.setHelpContext(HELP_CONTEXT);
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_PUSH);
        this.setNeedsProgressMonitor(true);
    }

    private static String getURIsString(Collection<URIish> uris) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (URIish uri : uris) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(uri);
        }
        return sb.toString();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.repoPage);
        this.addPage((IWizardPage)this.refSpecPage);
        this.addPage((IWizardPage)this.confirmPage);
    }

    public boolean canFinish() {
        RepositorySelection sel;
        if (this.getContainer().getCurrentPage() == this.repoPage && (sel = this.repoPage.getSelection()).isConfigSelected()) {
            RemoteConfig config = sel.getConfig();
            return !config.getPushURIs().isEmpty() || !config.getURIs().isEmpty();
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        boolean calledFromRepoPage = false;
        if (this.getContainer().getCurrentPage() == this.repoPage) {
            calledFromRepoPage = true;
        }
        if (this.repoPage.getSelection().isConfigSelected() && this.refSpecPage.isSaveRequested()) {
            this.saveRefSpecs();
        }
        if (this.repoPage.getStoreInSecureStore() && !SecureStoreUtils.storeCredentials((UserPasswordCredentials)this.repoPage.getCredentials(), (URIish)this.repoPage.getSelection().getURI())) {
            return false;
        }
        PushOperation operation = this.createPushOperation(calledFromRepoPage);
        if (operation == null) {
            return false;
        }
        UserPasswordCredentials credentials = this.repoPage.getCredentials();
        if (credentials != null) {
            operation.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider(credentials.getUser(), credentials.getPassword()));
        }
        PushJob job = new PushJob(this.localDb, operation, null, CustomPushWizard.getDestinationString(this.repoPage.getSelection()));
        job.setUser(true);
        job.schedule();
        return true;
    }

    public String getWindowTitle() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.repoPage || currentPage == null) {
            return UIText.PushWizard_windowTitleDefault;
        }
        return NLS.bind((String)UIText.PushWizard_windowTitleWithDestination, (Object)CustomPushWizard.getDestinationString(this.repoPage.getSelection()));
    }

    private void saveRefSpecs() {
        RemoteConfig rc = this.repoPage.getSelection().getConfig();
        rc.setPushRefSpecs(this.refSpecPage.getRefSpecs());
        StoredConfig config = this.localDb.getConfig();
        rc.update((Config)config);
        try {
            config.save();
        }
        catch (IOException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)UIText.PushWizard_cantSaveTitle, (String)UIText.PushWizard_cantSaveMessage, (IStatus)new Status(2, Activator.getPluginId(), e.getMessage(), (Throwable)e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PushOperation createPushOperation(boolean calledFromRepoPage) {
        Collection updates;
        PushOperationSpecification spec;
        block7: {
            RemoteConfig config = this.repoPage.getSelection().getConfig();
            if (calledFromRepoPage) {
                ArrayList pushSpecs = new ArrayList();
                pushSpecs.addAll(config.getPushRefSpecs());
                Collection updates2 = Transport.findRemoteRefUpdatesFor((Repository)this.localDb, pushSpecs, (Collection)config.getFetchRefSpecs());
                spec = new PushOperationSpecification();
                for (URIish uri : this.repoPage.getSelection().getPushURIs()) {
                    spec.addURIRefUpdates(uri, CustomConfirmationPage.copyUpdates(updates2));
                }
                return new PushOperation(this.localDb, spec, false, Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout"));
            }
            if (this.confirmPage.isConfirmed()) {
                PushOperationResult confirmedResult = this.confirmPage.getConfirmedResult();
                spec = confirmedResult.deriveSpecification(false);
                return new PushOperation(this.localDb, spec, false, Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout"));
            }
            List fetchSpecs = config != null ? config.getFetchRefSpecs() : null;
            updates = Transport.findRemoteRefUpdatesFor((Repository)this.localDb, (Collection)this.refSpecPage.getRefSpecs(), (Collection)fetchSpecs);
            if (!updates.isEmpty()) break block7;
            ErrorDialog.openError((Shell)this.getShell(), (String)UIText.PushWizard_missingRefsTitle, null, (IStatus)new Status(4, Activator.getPluginId(), UIText.PushWizard_missingRefsMessage));
            return null;
        }
        try {
            spec = new PushOperationSpecification();
            for (URIish uri : this.repoPage.getSelection().getPushURIs()) {
                spec.addURIRefUpdates(uri, CustomConfirmationPage.copyUpdates(updates));
            }
            return new PushOperation(this.localDb, spec, false, Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout"));
        }
        catch (IOException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)UIText.PushWizard_cantPrepareUpdatesTitle, (String)UIText.PushWizard_cantPrepareUpdatesMessage, (IStatus)new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e));
            return null;
        }
    }

    static String getDestinationString(RepositorySelection repoSelection) {
        if (repoSelection.isConfigSelected()) {
            return repoSelection.getConfigName();
        }
        return repoSelection.getURI(true).toString();
    }

    static class PushJob
    extends Job {
        private final PushOperation operation;
        private final PushOperationResult resultToCompare;
        private final String destinationString;
        private Repository localDb;

        public PushJob(Repository localDb, PushOperation operation, PushOperationResult resultToCompare, String destinationString) {
            super(NLS.bind((String)UIText.PushWizard_jobName, (Object)CustomPushWizard.getURIsString(operation.getSpecification().getURIs())));
            this.operation = operation;
            this.resultToCompare = resultToCompare;
            this.destinationString = destinationString;
            this.localDb = localDb;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.operation.run(monitor);
            }
            catch (InvocationTargetException e) {
                return new Status(4, Activator.getPluginId(), UIText.PushWizard_unexpectedError, e.getCause());
            }
            PushOperationResult result = this.operation.getOperationResult();
            if (!result.isSuccessfulConnectionForAnyURI()) {
                return new Status(4, Activator.getPluginId(), NLS.bind((String)UIText.PushWizard_cantConnectToAny, (Object)result.getErrorStringForAllURis()));
            }
            if (this.resultToCompare == null || !result.equals((Object)this.resultToCompare)) {
                CustomPushResultDialog.show(this.localDb, result, this.destinationString, true, false);
            }
            return Status.OK_STATUS;
        }
    }
}

