/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.components.wizards;

import com.kms.katalon.composer.integration.git.constants.GitStringConstants;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RefContentAssistProvider;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CustomPullWizardPage
extends WizardPage {
    private RemoteConfig remoteConfig;
    private RefContentAssistProvider assist;
    private Repository repository;
    private String fullBranch;
    private CreateLocalBranchOperation.UpstreamConfig upstreamConfig;
    private ComboViewer remoteBranchNameComboViewer;
    private Button refreshButton;
    private ControlDecoration missingBranchDecorator;
    private boolean configureUpstream;
    private Set<Resource> disposables = new HashSet<Resource>();

    public CustomPullWizardPage(Repository repository) {
        super(UIText.PullWizardPage_PageName);
        this.setTitle(UIText.PullWizardPage_PageTitle);
        this.setMessage(UIText.PullWizardPage_PageMessage);
        this.setImageDescriptor(UIIcons.WIZBAN_PULL);
        this.repository = repository;
        try {
            this.fullBranch = repository.getFullBranch();
        }
        catch (IOException ex) {
            Activator.logError((String)ex.getMessage(), (Throwable)ex);
        }
    }

    public void createControl(Composite parent) {
        this.setDefaultUpstreamConfig();
        Composite res = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)res);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(res);
        Composite sourceComposite = new Composite(res, 0);
        sourceComposite.setLayoutData((Object)GridDataFactory.fillDefaults().indent(UIUtils.getControlIndent(), 0).create());
        RowLayout rowLayout = RowLayoutFactory.fillDefaults().create();
        rowLayout.center = true;
        sourceComposite.setLayout((Layout)rowLayout);
        Label sourceLabel = new Label(sourceComposite, 0);
        sourceLabel.setText(GitStringConstants.LBL_CURRENT_BRANCH_NAME);
        if (this.fullBranch != null) {
            Label localBranchLabel = new Label(sourceComposite, 0);
            localBranchLabel.setText(Repository.shortenRefName((String)this.fullBranch));
            Image branchIcon = UIIcons.BRANCH.createImage();
            this.disposables.add((Resource)branchIcon);
            Label branchIconLabel = new Label(sourceComposite, 0);
            branchIconLabel.setLayoutData((Object)new RowData(branchIcon.getBounds().width, branchIcon.getBounds().height));
            branchIconLabel.setImage(branchIcon);
        }
        Composite remoteGroup = new Composite(res, 0);
        remoteGroup.setLayoutData((Object)GridDataFactory.fillDefaults().indent(UIUtils.getControlIndent(), 0).create());
        remoteGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(4).create());
        Label branchNameLabel = new Label(remoteGroup, 0);
        branchNameLabel.setText(GitStringConstants.LBL_REMOTE_BRANCH_NAME);
        this.remoteBranchNameComboViewer = new ComboViewer(remoteGroup, 12);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(300, -1).applyTo(this.remoteBranchNameComboViewer.getControl());
        this.remoteBranchNameComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.remoteBranchNameComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Ref) {
                    return Repository.shortenRefName((String)((Ref)element).getName());
                }
                return super.getText(element);
            }
        });
        this.remoteBranchNameComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CustomPullWizardPage.this.checkPage();
            }
        });
        this.refreshButton = new Button(remoteGroup, 0);
        this.refreshButton.setText(GitStringConstants.LBL_REFRESH_BUTTON);
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CustomPullWizardPage.this.assist == null) {
                    return;
                }
                CustomPullWizardPage.this.refreshRemoteBranchList(CustomPullWizardPage.this.assist.getRemoteURI());
            }
        });
        this.setPageComplete(this.isPageComplete());
        this.setControl((Control)res);
    }

    private void setRefAssist(RemoteConfig config) {
        if (config != null && config.getURIs().size() > 0) {
            this.refreshRemoteBranchList((URIish)config.getURIs().get(0));
        }
    }

    public void refreshRemoteBranchList(URIish uri) {
        this.assist = new RefContentAssistProvider(this.repository, uri, this.getShell());
        List refs = this.assist.getRefsForContentAssist(false, true);
        Collections.sort(refs, new Comparator<Ref>(){

            @Override
            public int compare(Ref ref1, Ref ref2) {
                return StringUtils.compareWithCase((String)Repository.shortenRefName((String)ref1.getName()), (String)Repository.shortenRefName((String)ref2.getName()));
            }
        });
        this.remoteBranchNameComboViewer.setInput((Object)refs);
        String suggestedBranchName = this.getSuggestedBranchName();
        for (Ref ref : refs) {
            if (!Repository.shortenRefName((String)ref.getName()).equals(suggestedBranchName)) continue;
            this.remoteBranchNameComboViewer.setSelection((ISelection)new StructuredSelection((Object)ref));
            break;
        }
    }

    void setSelectedRemote(RemoteConfig config) {
        this.remoteConfig = config;
        this.setRefAssist(this.remoteConfig);
        this.checkPage();
    }

    public boolean isPageComplete() {
        return this.remoteConfig != null && !this.remoteBranchNameComboViewer.getSelection().isEmpty();
    }

    private void checkPage() {
        block12: {
            block11: {
                try {
                    if (this.remoteConfig != null) break block11;
                    this.setErrorMessage(UIText.PushBranchPage_ChooseRemoteError);
                }
                catch (Throwable throwable) {
                    this.setPageComplete(this.getErrorMessage() == null);
                    throw throwable;
                }
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            String branchNameMessage = null;
            if (this.assist.getRefsForContentAssist(false, true).isEmpty()) {
                branchNameMessage = GitStringConstants.HAND_ERROR_MSG_NO_REMOTE_BRANCHES_FOUND;
            } else if (this.remoteBranchNameComboViewer.getSelection().isEmpty()) {
                branchNameMessage = MessageFormat.format(UIText.PullWizardPage_ChooseReference, this.remoteConfig.getName());
            }
            if (branchNameMessage == null) break block12;
            this.setErrorMessage(branchNameMessage);
            if (this.missingBranchDecorator == null) {
                this.missingBranchDecorator = new ControlDecoration(this.remoteBranchNameComboViewer.getControl(), 16512);
                this.missingBranchDecorator.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
            }
            this.missingBranchDecorator.setDescriptionText(branchNameMessage);
            this.missingBranchDecorator.show();
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        if (this.missingBranchDecorator != null) {
            this.missingBranchDecorator.hide();
        }
        if (this.overrideUpstreamConfiguration() && this.hasDifferentUpstreamConfiguration()) {
            this.setMessage(UIText.PushBranchPage_UpstreamConfigOverwriteWarning, 2);
        } else {
            this.setMessage(UIText.PullWizardPage_PageMessage);
        }
        this.setErrorMessage(null);
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private String getSuggestedBranchName() {
        if (this.fullBranch == null) {
            return "";
        }
        String branchName = Repository.shortenRefName((String)this.fullBranch);
        StoredConfig config = this.repository.getConfig();
        BranchConfig branchConfig = new BranchConfig((Config)config, branchName);
        String merge = branchConfig.getMerge();
        if (!branchConfig.isRemoteLocal() && merge != null && merge.startsWith("refs/heads/")) {
            return Repository.shortenRefName((String)merge);
        }
        if (merge == null && this.fullBranch.startsWith("refs/heads/")) {
            return branchName;
        }
        return "";
    }

    boolean overrideUpstreamConfiguration() {
        return this.configureUpstream;
    }

    boolean isRebaseSelected() {
        return this.upstreamConfig == CreateLocalBranchOperation.UpstreamConfig.REBASE;
    }

    CreateLocalBranchOperation.UpstreamConfig getUpstreamConfig() {
        return this.upstreamConfig;
    }

    private boolean hasDifferentUpstreamConfiguration() {
        String branchName = Repository.shortenRefName((String)this.fullBranch);
        BranchConfig branchConfig = new BranchConfig((Config)this.repository.getConfig(), branchName);
        String remote = branchConfig.getRemote();
        if (remote == null) {
            return false;
        }
        if (!remote.equals(this.remoteConfig.getName())) {
            return true;
        }
        String merge = branchConfig.getMerge();
        if (merge == null || !merge.equals(this.getFullRemoteReference())) {
            return true;
        }
        return branchConfig.isRebase() ^ this.isRebaseSelected();
    }

    private void setDefaultUpstreamConfig() {
        CreateLocalBranchOperation.UpstreamConfig config;
        String branchName = Repository.shortenRefName((String)this.fullBranch);
        BranchConfig branchConfig = new BranchConfig((Config)this.repository.getConfig(), branchName);
        CreateLocalBranchOperation.UpstreamConfig upstreamConfig = config = branchConfig.isRebase() ? CreateLocalBranchOperation.UpstreamConfig.REBASE : CreateLocalBranchOperation.UpstreamConfig.MERGE;
        if (branchConfig.getMerge() == null) {
            config = CreateLocalBranchOperation.UpstreamConfig.getDefault((Repository)this.repository, (String)("refs/remotes/origin/" + branchName));
        }
        this.upstreamConfig = config;
    }

    String getFullRemoteReference() {
        IStructuredSelection selection = (IStructuredSelection)this.remoteBranchNameComboViewer.getSelection();
        return ((Ref)selection.getFirstElement()).getName();
    }

    RemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    public void dispose() {
        super.dispose();
        if (this.missingBranchDecorator != null) {
            this.missingBranchDecorator.dispose();
        }
        for (Resource disposable : this.disposables) {
            disposable.dispose();
        }
    }
}

