/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.components.wizards;

import com.kms.katalon.composer.integration.git.components.wizards.CustomRepositorySelectionPage;
import com.kms.katalon.composer.integration.git.components.wizards.CustomSourceBranchPage;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.fetch.FetchOperationUI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class CustomGitFetchWizard
extends Wizard {
    private final Repository localDb;
    private final CustomRepositorySelectionPage repoPage;
    private final CustomSourceBranchPage validSource;

    public CustomGitFetchWizard(Repository localDb) throws URISyntaxException {
        this.localDb = localDb;
        List remotes = RemoteConfig.getAllRemoteConfigs((Config)localDb.getConfig());
        this.repoPage = new CustomRepositorySelectionPage(true, remotes, null);
        this.validSource = new CustomSourceBranchPage(){

            public void setVisible(boolean visible) {
                RepositorySelection selection = CustomGitFetchWizard.this.getRepositorySelection();
                if (selection != null && visible) {
                    this.setSelection(selection);
                    this.setCredentials(CustomGitFetchWizard.this.getCredentials());
                }
                super.setVisible(visible);
            }
        };
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_FETCH);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.repoPage);
        this.addPage((IWizardPage)this.validSource);
    }

    protected RepositorySelection getRepositorySelection() {
        try {
            return new RepositorySelection(new URIish(this.repoPage.getGitRepositoryInfo().getCloneUri()), null);
        }
        catch (URISyntaxException e) {
            Activator.error((String)UIText.GitImportWizard_errorParsingURI, (Throwable)e);
            return null;
        }
        catch (Exception e) {
            Activator.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected UserPasswordCredentials getCredentials() {
        try {
            return this.repoPage.getGitRepositoryInfo().getCredentials();
        }
        catch (Exception e) {
            Activator.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() != this.repoPage) {
            return super.canFinish();
        }
        RepositorySelection sel = this.repoPage.getSelection();
        if (sel.isConfigSelected()) {
            RemoteConfig config = sel.getConfig();
            return !config.getURIs().isEmpty() && !config.getFetchRefSpecs().isEmpty();
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        if (this.repoPage.getStoreInSecureStore() && !SecureStoreUtils.storeCredentials((UserPasswordCredentials)this.repoPage.getCredentials(), (URIish)this.repoPage.getSelection().getURI())) {
            return false;
        }
        int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
        RepositorySelection repoSelection = this.repoPage.getSelection();
        FetchOperationUI op = new FetchOperationUI(this.localDb, repoSelection.getURI(false), CustomGitFetchWizard.getDefaultRefSpecs(), timeout, false);
        UserPasswordCredentials credentials = this.repoPage.getCredentials();
        if (credentials != null) {
            op.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider(credentials.getUser(), credentials.getPassword()));
        }
        op.start();
        this.saveConfig();
        return true;
    }

    private void saveConfig() {
        try {
            RemoteConfig rc = new RemoteConfig((Config)this.localDb.getConfig(), "origin");
            rc.setFetchRefSpecs(CustomGitFetchWizard.getDefaultRefSpecs());
            rc.setTagOpt(TagOpt.FETCH_TAGS);
            rc.addURI(this.repoPage.getSelection().getURI());
            StoredConfig config = this.localDb.getConfig();
            rc.update((Config)config);
            config.save();
        }
        catch (IOException | URISyntaxException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)UIText.FetchWizard_cantSaveTitle, (String)UIText.FetchWizard_cantSaveMessage, (IStatus)new Status(2, Activator.getPluginId(), e.getMessage(), (Throwable)e));
        }
    }

    public String getWindowTitle() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.repoPage || currentPage == null) {
            return UIText.FetchWizard_windowTitleDefault;
        }
        return NLS.bind((String)UIText.FetchWizard_windowTitleWithSource, (Object)this.getSourceString());
    }

    public static List<RefSpec> getDefaultRefSpecs() {
        ArrayList<RefSpec> refSpecs = new ArrayList<RefSpec>();
        refSpecs.add(Transport.REFSPEC_PUSH_ALL);
        refSpecs.add(Transport.REFSPEC_TAGS);
        return refSpecs;
    }

    private String getSourceString() {
        RepositorySelection repoSelection = this.repoPage.getSelection();
        if (repoSelection.isConfigSelected()) {
            return repoSelection.getConfigName();
        }
        return repoSelection.getURI(false).toString();
    }
}

