/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.components.wizards;

import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.explorer.handlers.RefreshHandler;
import com.kms.katalon.composer.integration.git.components.wizards.CustomCreateBranchPage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class CustomCreateBranchWizard
extends Wizard {
    private String newBranchName;
    private CustomCreateBranchPage myPage;

    public CustomCreateBranchWizard(Repository repository) {
        this(repository, null);
    }

    public CustomCreateBranchWizard(Repository repository, String base) {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (RevWalk rw = new RevWalk(repository);){
                if (base == null) {
                    this.myPage = new CustomCreateBranchPage(repository, null);
                } else if (ObjectId.isId((String)base)) {
                    RevCommit commit = rw.parseCommit((AnyObjectId)ObjectId.fromString((String)base));
                    this.myPage = new CustomCreateBranchPage(repository, commit);
                } else if (base.startsWith("refs/heads/") || base.startsWith("refs/remotes/") || base.startsWith("refs/tags/")) {
                    Ref currentBranch = repository.exactRef(base);
                    this.myPage = new CustomCreateBranchPage(repository, currentBranch);
                } else {
                    RevCommit commit = rw.parseCommit((AnyObjectId)repository.resolve(String.valueOf(base) + "^{commit}"));
                    this.myPage = new CustomCreateBranchPage(repository, commit);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            this.myPage = new CustomCreateBranchPage(repository, null);
        }
        this.setWindowTitle(UIText.CreateBranchWizard_NewBranchTitle);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.myPage);
    }

    public boolean performFinish() {
        final CustomCreateBranchPage cp = (CustomCreateBranchPage)this.getPages()[0];
        this.newBranchName = cp.getBranchName();
        final boolean checkoutNewBranch = cp.checkoutNewBranch();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        cp.createBranch(CustomCreateBranchWizard.this.newBranchName, checkoutNewBranch, monitor);
                    }
                    catch (CoreException ce) {
                        throw new InvocationTargetException(ce);
                    }
                    catch (IOException ioe) {
                        throw new InvocationTargetException(ioe);
                    }
                }
            });
            UISynchronizeService.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    new RefreshHandler().execute();
                }
            });
        }
        catch (InvocationTargetException ite) {
            Activator.handleError((String)UIText.CreateBranchWizard_CreationFailed, (Throwable)ite.getCause(), (boolean)true);
            return false;
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    public String getNewBranchName() {
        return this.newBranchName;
    }
}

