/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.markers;

import cucumber.eclipse.editor.Activator;
import cucumber.eclipse.editor.markers.IMarkerManager;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class MarkerManager
implements IMarkerManager {
    @Override
    public void add(String type, IFile file, int severity, String message, int lineNumber, int charStart, int charEnd) {
        HashMap<String, Integer> attributes = new HashMap<String, Integer>();
        attributes.put("severity", severity);
        MarkerUtilities.setMessage(attributes, (String)message);
        MarkerUtilities.setLineNumber(attributes, (int)lineNumber);
        MarkerUtilities.setCharStart(attributes, (int)charStart);
        MarkerUtilities.setCharEnd(attributes, (int)charEnd);
        try {
            MarkerUtilities.createMarker((IResource)file, attributes, (String)type);
        }
        catch (CoreException exception) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "cucumber.eclipse.editor", String.format("Couldn't write marker %s for %s", type, file), (Throwable)exception));
        }
    }

    @Override
    public void removeAll(String type, IFile file) {
        try {
            file.deleteMarkers(type, true, 0);
        }
        catch (CoreException exception) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "cucumber.eclipse.editor", String.format("Couldn't remove markers %s from %s", type, file), (Throwable)exception));
        }
    }
}

