/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors;

import cucumber.eclipse.steps.integration.Step;
import gherkin.I18n;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class StepMatcher {
    private Pattern variablePattern = Pattern.compile("<([^>]+)>");
    private Pattern groupPatternNonParameterMatch = Pattern.compile("(\\(\\?:.+?\\))");
    private Pattern groupPattern = Pattern.compile("(\\(.+?\\))");

    StepMatcher() {
    }

    public String getTextStatement(String language, String expression) {
        Matcher matcher = this.getBasicStatementMatcher(language, expression);
        if (matcher == null) {
            return null;
        }
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private Matcher getBasicStatementMatcher(String language, String text) {
        Pattern cukePattern = this.getLanguageKeyWordMatcher(language);
        if (cukePattern == null) {
            return null;
        }
        return cukePattern.matcher(text.trim());
    }

    public Step matchSteps(String languageCode, Set<Step> steps, String currentLine) {
        Matcher matcher = this.getBasicStatementMatcher(languageCode, currentLine);
        if (matcher.matches()) {
            String cukeStep = matcher.group(1);
            Matcher variableMatcher = this.variablePattern.matcher(cukeStep);
            cukeStep = variableMatcher.replaceAll("<p>");
            for (Step step : steps) {
                Matcher groupNonParameterMatcher = this.groupPatternNonParameterMatch.matcher(step.getText());
                while (groupNonParameterMatcher.find()) {
                    step.setText(step.getText().replace(groupNonParameterMatcher.group(0), "(" + groupNonParameterMatcher.group(0).substring(3)));
                }
                Matcher groupMatcher = this.groupPattern.matcher(step.getText());
                while (groupMatcher.find()) {
                    if (groupMatcher.group(0).startsWith("(<p>|")) break;
                    step.setText(step.getText().replace(groupMatcher.group(0), "(<p>|" + groupMatcher.group(0).substring(1)));
                }
                if (!step.matches(cukeStep)) continue;
                return step;
            }
        }
        return null;
    }

    private Pattern getLanguageKeyWordMatcher(String languageCode) {
        try {
            if (languageCode == null) {
                languageCode = "en";
            }
            I18n i18n = new I18n(languageCode);
            StringBuilder sb = new StringBuilder();
            sb.append("(?:");
            String delim = "";
            for (String keyWord : i18n.getStepKeywords()) {
                sb.append(delim).append(Pattern.quote(keyWord));
                delim = "|";
            }
            return Pattern.compile(sb.append(")(.*)$").toString());
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return null;
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }
}

