/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors;

import cucumber.eclipse.steps.integration.Step;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class StepHyperlink
implements IHyperlink {
    private IRegion region;
    private Step step;

    public StepHyperlink(IRegion region, Step step) {
        this.region = region;
        this.step = step;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return "Open step definition";
    }

    public String getTypeLabel() {
        return "Gherkin step";
    }

    public void open() {
        IResource file = this.step.getSource();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("lineNumber", this.step.getLineNumber());
        try {
            IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
            marker.setAttributes(map);
            IDE.openEditor((IWorkbenchPage)page, (IMarker)marker);
            marker.delete();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

