/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors;

import cucumber.eclipse.editor.Activator;
import cucumber.eclipse.editor.contentassist.CucumberContentAssist;
import cucumber.eclipse.editor.editors.DocumentUtil;
import cucumber.eclipse.editor.editors.Editor;
import gherkin.I18n;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

public class GherkinKeywordsAssistProcessor
implements IContentAssistProcessor {
    private static final List<String> FEATURE_ELEMENT_KEYWORD_KEYS = Arrays.asList("feature", "background", "scenario", "scenario_outline", "examples");
    private final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    public final Image ICON = Activator.getImageDescriptor("icons/cukes.gif").createImage();
    private CucumberContentAssist contentAssist = null;
    private Editor editor;

    public GherkinKeywordsAssistProcessor(Editor editor) {
        this.editor = editor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            List<String> junks;
            IDocument document = viewer.getDocument();
            String lang = DocumentUtil.getDocumentLanguage(document);
            if (lang == null) {
                lang = "en";
            }
            I18n i18n = new I18n(lang);
            this.contentAssist = new CucumberContentAssist(lang, this.editor.getStepProvider());
            List<String> stepKeyWords = this.contentAssist.getStepKeyWords(i18n);
            IRegion line = viewer.getDocument().getLineInformationOfOffset(offset);
            String typed = viewer.getDocument().get(line.getOffset(), offset - line.getOffset()).replaceAll(this.contentAssist.STARTSWITH_ANYSPACE, "");
            String preStep = viewer.getDocument().get(line.getOffset(), line.getLength()).replaceAll(this.contentAssist.STARTSWITH_ANYSPACE, "");
            preStep = this.contentAssist.lastPrefix(preStep, stepKeyWords);
            ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
            List<String> keywordList = this.allKeywords(i18n);
            if (keywordList.containsAll(junks = this.contentAssist.getJunkList())) {
                keywordList.removeAll(junks);
            }
            if (typed.length() > 0) {
                for (String stepKeyWord : stepKeyWords) {
                    if (stepKeyWord.trim().startsWith(typed)) {
                        this.addStepWordCompletionProposal(offset, typed, result, stepKeyWord);
                        continue;
                    }
                    if (!typed.startsWith(stepKeyWord)) continue;
                    this.addStepDetailsProposal(offset, typed, preStep, result, stepKeyWords);
                }
            } else {
                for (String string : keywordList) {
                    CompletionProposal p = new CompletionProposal(string, offset, 0, string.length(), this.ICON, null, null, null);
                    result.add((ICompletionProposal)p);
                }
            }
            return result.toArray(new ICompletionProposal[result.size()]);
        }
        catch (Exception exception) {
            return this.NO_COMPLETIONS;
        }
    }

    private void addStepDetailsProposal(int offset, String typed, String preStep, ArrayList<ICompletionProposal> result, List<String> stepKeyWords) {
        String lastPrefix = this.contentAssist.lastPrefix(typed, stepKeyWords);
        this.contentAssist.collectAllSteps(lastPrefix);
        List<String> stepDetailList = this.contentAssist.importAllStepList();
        List<String> matchedStepList = this.contentAssist.importMatchedStepList();
        if (matchedStepList.isEmpty() && stepDetailList.isEmpty()) {
            this.contentAssist.displayNoProposal(offset, this.ICON, result);
        } else if (!matchedStepList.isEmpty()) {
            for (String step : matchedStepList) {
                if (step.startsWith(lastPrefix)) {
                    this.contentAssist.importStepProposals(lastPrefix, preStep, offset, this.ICON, step, result);
                    continue;
                }
                if (!step.contains(lastPrefix)) continue;
                this.contentAssist.importStepProposals(lastPrefix, preStep, offset, this.ICON, step, result);
            }
        } else if (lastPrefix.matches(this.contentAssist.STARTS_ANY) && matchedStepList.isEmpty()) {
            this.contentAssist.displayNoProposal(offset, this.ICON, result);
        } else if (lastPrefix.matches(this.contentAssist.COMMA_SPACE_REGEX) | !stepDetailList.isEmpty()) {
            for (String step : stepDetailList) {
                this.contentAssist.importStepProposals(lastPrefix, preStep, offset, this.ICON, step, result);
            }
        } else {
            this.contentAssist.displayNoProposal(offset, this.ICON, result);
        }
    }

    private void addStepWordCompletionProposal(int offset, String typed, ArrayList<ICompletionProposal> result, String stepKeyWord) {
        CompletionProposal p = new CompletionProposal(stepKeyWord, offset - typed.length(), typed.length(), stepKeyWord.length(), this.ICON, null, null, null);
        result.add((ICompletionProposal)p);
    }

    private List<String> allKeywords(I18n i18n) {
        List keywords = i18n.getStepKeywords();
        for (String string : FEATURE_ELEMENT_KEYWORD_KEYS) {
            keywords.addAll(i18n.keywords(string));
        }
        return keywords;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return this.NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

