/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors;

import cucumber.eclipse.editor.Activator;
import cucumber.eclipse.editor.editors.ColorManager;
import cucumber.eclipse.editor.editors.GherkinConfiguration;
import cucumber.eclipse.editor.editors.GherkinDocumentProvider;
import cucumber.eclipse.editor.editors.GherkinErrorMarker;
import cucumber.eclipse.editor.editors.GherkinModel;
import cucumber.eclipse.editor.editors.GherkinOutlinePage;
import cucumber.eclipse.editor.editors.PositionedElement;
import cucumber.eclipse.editor.markers.MarkerManager;
import cucumber.eclipse.editor.steps.ExtensionRegistryStepProvider;
import cucumber.eclipse.editor.steps.IStepProvider;
import cucumber.eclipse.editor.template.GherkinSampleTemplate;
import cucumber.eclipse.steps.integration.IStepListener;
import cucumber.eclipse.steps.integration.StepsChangedEvent;
import gherkin.formatter.Formatter;
import gherkin.lexer.LexingError;
import gherkin.parser.Parser;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class Editor
extends TextEditor
implements IStepListener {
    private ColorManager colorManager = new ColorManager();
    private IEditorInput input;
    private ProjectionSupport projectionSupport;
    private ProjectionAnnotationModel annotationModel;
    private Annotation[] oldAnnotations;
    private GherkinOutlinePage outlinePage;
    private GherkinModel model;
    private ExtensionRegistryStepProvider stepProvider;

    public Editor() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new GherkinConfiguration(this, this.colorManager));
        this.setDocumentProvider((IDocumentProvider)new GherkinDocumentProvider(GherkinSampleTemplate.getFeatureTemplate()));
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
        IContextService service = (IContextService)this.getSite().getService(IContextService.class);
        if (service != null) {
            service.activateContext("cucumber.eclipse.editor.featureEditorScope");
        }
    }

    public void onStepsChanged(StepsChangedEvent event) {
        this.validateAndMark();
    }

    public GherkinModel getModel() {
        return this.model;
    }

    public IStepProvider getStepProvider() {
        return this.stepProvider;
    }

    public void updateGherkinModel(GherkinModel model) {
        this.validateAndMark();
        this.updateOutline(model.getFeatureElement());
        this.updateFoldingStructure(model.getFoldRanges());
    }

    public void updateFoldingStructure(List<Position> positions) {
        HashMap<ProjectionAnnotation, Position> newAnnotations = new HashMap<ProjectionAnnotation, Position>();
        for (Position p : positions) {
            newAnnotations.put(new ProjectionAnnotation(), p);
        }
        this.annotationModel.modifyAnnotations(this.oldAnnotations, newAnnotations, null);
        this.oldAnnotations = newAnnotations.keySet().toArray(new Annotation[0]);
    }

    TextSelection getSelection() {
        return (TextSelection)this.getSelectionProvider().getSelection();
    }

    private void updateOutline(PositionedElement featureElement) {
        if (this.outlinePage != null) {
            this.outlinePage.update(featureElement);
        }
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId("#CukeEditorContext");
    }

    protected void doSetInput(IEditorInput newInput) throws CoreException {
        super.doSetInput(newInput);
        this.input = newInput;
        this.model = new GherkinModel();
        this.stepProvider = new ExtensionRegistryStepProvider(((IFileEditorInput)newInput).getFile());
        this.stepProvider.addStepListener(this);
        this.stepProvider.reload();
    }

    public void dispose() {
        super.dispose();
        this.colorManager.dispose();
        if (this.stepProvider != null) {
            this.stepProvider.removeStepListener(this);
            this.stepProvider = null;
        }
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.outlinePage == null) {
                this.outlinePage = new GherkinOutlinePage();
                this.outlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        PositionedElement firstElement = (PositionedElement)((IStructuredSelection)event.getSelection()).getFirstElement();
                        if (firstElement != null) {
                            try {
                                Editor.this.selectAndReveal(firstElement.toPosition().getOffset(), 0);
                            }
                            catch (BadLocationException e) {
                                Activator.getDefault().getLog().log((IStatus)new Status(4, "cucumber.eclipse.editor", "Couldn't set editor selection from outline", (Throwable)e));
                            }
                        }
                    }
                });
            }
            this.outlinePage.setInput(this.getEditorInput());
            return this.outlinePage;
        }
        return super.getAdapter(required);
    }

    private void validateAndMark() {
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.input);
        IFileEditorInput fileEditorInput = (IFileEditorInput)this.input;
        IFile featureFile = fileEditorInput.getFile();
        MarkerManager markerManager = new MarkerManager();
        GherkinErrorMarker marker = new GherkinErrorMarker(this.stepProvider, markerManager, featureFile, doc);
        marker.removeExistingMarkers();
        Parser p = new Parser((Formatter)marker, false);
        try {
            p.parse(doc.get(), "", Integer.valueOf(0));
        }
        catch (LexingError l) {
            markerManager.add("cucumber.eclipse.editor.editors.Editor.lexingerror", featureFile, 2, l.getLocalizedMessage(), 1, 0, 0);
        }
    }
}

