/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.util.groovy;

import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorHistory;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.NavigationHistory;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.part.FileEditorInput;

public class editor {
    private static final String GROOVY_EDITOR_URI = "org.codehaus.groovy.eclipse.editor.GroovyEditor";

    public static MPart createTestCaseEditorPart(IFile scriptFile, MPartStack parentPartStack, String testCaseEditorId, EPartService partService, int index) {
        MPart editor2 = editor.createEditorPart(scriptFile, partService);
        editor2.setElementId(testCaseEditorId);
        parentPartStack.getChildren().add(index, editor2);
        return editor2;
    }

    public static MPart createEditorPart(ProjectEntity projectEntity, String filePath, EPartService partService) throws CoreException {
        IFile scriptFile = GroovyUtil.getGroovyProject((ProjectEntity)projectEntity).getFile(Path.fromOSString((String)filePath));
        scriptFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        return editor.createEditorPart(scriptFile, partService);
    }

    public static MPart createEditorPart(IFile scriptFile, EPartService partService) {
        MPart editor2 = partService.createPart("org.eclipse.e4.ui.compatibility.editor");
        FileEditorInput input = new FileEditorInput(scriptFile);
        editor2.getTags().add(GROOVY_EDITOR_URI);
        editor.createEditorReferenceForPart(editor2, (IEditorInput)input, GROOVY_EDITOR_URI, null);
        editor.updateActiveEditorSources(editor2);
        EditorDescriptor descriptor = (EditorDescriptor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getWorkbenchWindow().getWorkbench().getEditorRegistry().findEditor(GROOVY_EDITOR_URI);
        editor.recordEditor((IEditorInput)input, (IEditorDescriptor)descriptor);
        editor2.getTags().add("NoMove");
        return editor2;
    }

    private static void recordEditor(IEditorInput input, IEditorDescriptor descriptor) {
        WorkbenchPage page = (WorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        EditorHistory history = ((Workbench)page.getWorkbenchWindow().getWorkbench()).getEditorHistory();
        history.add(input, descriptor);
    }

    public static IEditorPart getEditor(MPart part) {
        Object clientObject;
        if (part != null && (clientObject = part.getObject()) instanceof CompatibilityEditor) {
            return ((CompatibilityEditor)clientObject).getEditor();
        }
        return null;
    }

    public static void saveEditor(MPart part) {
        if (!part.isDirty()) {
            return;
        }
        IEditorPart editor2 = editor.getEditor(part);
        if (editor2 instanceof GroovyEditor) {
            GroovyEditor groovyEditor = (GroovyEditor)editor2;
            GroovyCompilationUnit unit = groovyEditor.getGroovyCompilationUnit();
            try {
                try {
                    if (!unit.isWorkingCopy()) {
                        unit.becomeWorkingCopy(null);
                    }
                    unit.commitWorkingCopy(true, null);
                }
                catch (JavaModelException javaModelException) {
                    part.setDirty(false);
                }
            }
            finally {
                part.setDirty(false);
            }
            return;
        }
        editor2.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    public static boolean isGroovyEditorPart(MPart part) {
        IEditorPart editor2 = editor.getEditor(part);
        return editor2 instanceof GroovyEditor;
    }

    private static void updateActiveEditorSources(MPart part) {
        IEditorPart editor2 = editor.getEditor(part);
        WorkbenchPage page = (WorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        MWindow window = page.getWindowModel();
        window.getContext().set("activeEditorId", editor2 == null ? null : editor2.getSite().getId());
        window.getContext().set("activeEditor", (Object)editor2);
        window.getContext().set("activeEditorInput", (Object)(editor2 == null ? null : editor2.getEditorInput()));
        if (editor2 != null) {
            NavigationHistory navigationHistory = (NavigationHistory)page.getNavigationHistory();
            navigationHistory.markEditor(editor2);
        }
    }

    private static EditorReference createEditorReferenceForPart(MPart part, IEditorInput input, String editorId, IMemento memento) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        EditorDescriptor descriptor = (EditorDescriptor)registry.findEditor(editorId);
        WorkbenchPage page = (WorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        EditorReference ref = new EditorReference(page.getWindowModel().getContext(), (IWorkbenchPage)page, part, input, descriptor, memento);
        page.addEditorReference(ref);
        ref.subscribe();
        return ref;
    }

    public static void showProblems(GroovyEditor editor2) {
        IResource resource = null;
        try {
            resource = editor2.getGroovyCompilationUnit().getResource();
            editor.clearEditorProblems(editor2);
            String testScriptContent = editor2.getGroovyCompilationUnit().getSource();
            if (testScriptContent == null || testScriptContent.isEmpty()) {
                return;
            }
            new AstBuilder().buildFromString(CompilePhase.CONVERSION, testScriptContent);
        }
        catch (MultipleCompilationErrorsException ex) {
            try {
                SyntaxErrorMessage message = (SyntaxErrorMessage)ex.getErrorCollector().getError(0);
                SyntaxException syntaxException = message.getCause();
                int lineOffset = editor2.getViewer().getDocument().getLineOffset(syntaxException.getLine() - 1);
                IMarker marker = resource.createMarker("org.codehaus.groovy.eclipse.dsl.inferencing_problem");
                marker.setAttribute("priority", 2);
                marker.setAttribute("message", (Object)syntaxException.getMessage());
                marker.setAttribute("severity", 2);
                marker.setAttribute("lineNumber", syntaxException.getLine());
                marker.setAttribute("charStart", lineOffset + syntaxException.getStartColumn() - 1);
                marker.setAttribute("charEnd", lineOffset + syntaxException.getEndColumn() - 1);
                marker.setAttribute("location", (Object)String.format("line %d", syntaxException.getLine()));
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {}
    }

    public static void clearEditorProblems(GroovyEditor editor2) throws CoreException {
        IResource resource = editor2.getGroovyCompilationUnit().getResource();
        if (resource != null && resource.exists()) {
            resource.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
    }

    public static void insertScript(GroovyEditor editor2, int offset, String script) throws MalformedTreeException, BadLocationException {
        IEditorInput editorInput = editor2.getEditorInput();
        IDocument document = editor2.getDocumentProvider().getDocument((Object)editorInput);
        InsertEdit insertEdit = new InsertEdit(offset, script);
        insertEdit.apply(document);
    }
}

