/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.util.groovy;

import com.kms.katalon.composer.util.groovy.GroovyCompilationHelper;
import com.kms.katalon.composer.util.groovy.ImportType;
import com.kms.katalon.core.ast.GroovyParser;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;

public class GroovyGuiUtil {
    public static ICompilationUnit createGroovyScriptForCustomKeyword(IPackageFragment parentPackage, String typeName) throws CoreException {
        return GroovyCompilationHelper.createGroovyType(parentPackage, typeName, false, ImportType.KEYWORD_IMPORTS);
    }

    public static ICompilationUnit createGroovyScriptForCustomKeywordFromTemplate(IPackageFragment parentPackage, String typeName, String template) throws CoreException {
        return GroovyCompilationHelper.createGroovyTypeFromString(parentPackage, typeName, template);
    }

    public static ICompilationUnit getOrCreateGroovyScriptForTestCase(TestCaseEntity testCase) throws CoreException, IOException {
        GroovyUtil.getTestCaseScriptFolder((TestCaseEntity)testCase);
        IProject groovyProject = GroovyUtil.getGroovyProject((ProjectEntity)testCase.getProject());
        String parentRelativeFolder = GroovyUtil.getScriptPackageRelativePathForTestCase((TestCaseEntity)testCase);
        IFolder parentFolder = groovyProject.getFolder(parentRelativeFolder);
        if (!parentFolder.exists()) {
            parentFolder.getParent().refreshLocal(1, null);
        }
        parentFolder.refreshLocal(1, null);
        String scriptFileName = GroovyUtil.getScriptNameForTestCase((TestCaseEntity)testCase);
        IFile scriptFile = null;
        if (scriptFileName == null) {
            scriptFileName = GroovyUtil.getGroovyClassName((TestCaseEntity)testCase);
            scriptFile = parentFolder.getFile(String.valueOf(scriptFileName) + ".groovy");
            scriptFile.getLocation().toFile().createNewFile();
            GroovyCompilationUnit newCompilationunit = (GroovyCompilationUnit)GroovyCompilationHelper.createGroovyType(GroovyUtil.getDefaultPackageForTestCase((ProjectEntity)testCase.getProject()), scriptFileName);
            StringBuilder importBuilder = new StringBuilder();
            GroovyParser parser = new GroovyParser(importBuilder);
            parser.parseGroovyAstIntoScript(Arrays.asList((ClassNode)newCompilationunit.getModuleNode().getClasses().get(0)));
            FileUtils.writeStringToFile((File)scriptFile.getLocation().toFile(), (String)importBuilder.toString());
            scriptFile.refreshLocal(0, null);
            newCompilationunit.getResource().delete(true, null);
        } else {
            scriptFile = parentFolder.getFile(String.valueOf(scriptFileName) + ".groovy");
        }
        return JavaCore.createCompilationUnitFrom((IFile)scriptFile);
    }

    public static void addContentToTestCase(TestCaseEntity testCase, String content) throws Exception {
        ICompilationUnit unit = GroovyGuiUtil.getOrCreateGroovyScriptForTestCase(testCase);
        if (unit == null) {
            return;
        }
        FileUtils.writeStringToFile((File)unit.getResource().getLocation().toFile(), (String)content, (Charset)Charset.forName("UTF-8"));
    }

    public static void addContentToTestCase(TestCaseEntity testCase, InputStream content) throws Exception {
        ICompilationUnit unit = GroovyGuiUtil.getOrCreateGroovyScriptForTestCase(testCase);
        if (unit == null) {
            return;
        }
        FileUtils.copyInputStreamToFile((InputStream)content, (File)unit.getResource().getLocation().toFile());
    }

    public static URLClassLoader getProjectClasLoader(ProjectEntity projectEntity) throws MalformedURLException, CoreException {
        IJavaProject project = JavaCore.create((IProject)GroovyUtil.getGroovyProject((ProjectEntity)projectEntity));
        return GroovyUtil.getProjectClasLoader((IJavaProject)project, (String[])JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project));
    }
}

