/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.wizards;

import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.util.JUnitStatus;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageOne;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageTwo;

public class NewGroovyTestTypeWizardPage
extends NewTestCaseWizardPageOne {
    private static final String DOT_GROOVY = ".groovy";
    private static final String GROOVY_TEST_CASE = "groovy.util.GroovyTestCase";
    protected static final String GROOVY_NATURE_ERROR_MSG = "Project is not a Groovy Project. Please select a Groovy project.";
    private IType maybeCreatedType;

    public NewGroovyTestTypeWizardPage(NewTestCaseWizardPageTwo page2) {
        super(page2);
    }

    protected String getCompilationUnitName(String typeName) {
        return String.valueOf(typeName) + DOT_GROOVY;
    }

    protected String getJUnit3TestSuperclassName() {
        return GROOVY_TEST_CASE;
    }

    public IType getCreatedType() {
        return this.maybeCreatedType != null ? this.maybeCreatedType : super.getCreatedType();
    }

    protected boolean hasGroovyNature() {
        IProject project = this.getProject();
        if (project != null) {
            return GroovyNature.hasGroovyNature((IProject)project);
        }
        return false;
    }

    protected IProject getProject() {
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null) {
            return null;
        }
        return javaProject.getProject();
    }

    protected IStatus superClassChanged() {
        if (this.isJUnit4()) {
            return super.superClassChanged();
        }
        String superClassName = this.getSuperClass();
        if (GROOVY_TEST_CASE.equals(superClassName)) {
            return new JUnitStatus();
        }
        return super.superClassChanged();
    }

    public int getModifiers() {
        int modifiers = super.getModifiers();
        modifiers &= ~this.F_PUBLIC;
        modifiers &= ~this.F_PRIVATE;
        return modifiers &= ~this.F_PROTECTED;
    }

    protected void updateStatus(IStatus status) {
        if (!this.hasGroovyNature()) {
            super.updateStatus((IStatus)new Status(4, "org.codehaus.groovy.eclipse.ui", GROOVY_NATURE_ERROR_MSG));
            return;
        }
        super.updateStatus(status);
    }

    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (!this.hasGroovyNature()) {
            GroovyCore.logWarning((String)GROOVY_NATURE_ERROR_MSG);
            return;
        }
        IPackageFragment pack = this.getPackageFragment();
        if (pack == null) {
            pack = this.getPackageFragmentRoot().getPackageFragment("");
        }
        if (!this.isJUnit4() && this.getPackageFragment().getElementName().equals("")) {
            this.createTypeInDefaultPackageJUnit3(pack, monitor);
        } else {
            super.createType(monitor);
        }
    }

    private void createTypeInDefaultPackageJUnit3(IPackageFragment pack, IProgressMonitor monitor) throws JavaModelException {
        StringBuffer sb = new StringBuffer();
        String superClass = this.getSuperClass();
        String typeName = this.getTypeName();
        String[] splits = superClass.split("\\.");
        if (superClass != null && !superClass.equals(GROOVY_TEST_CASE)) {
            if (splits.length > 1) {
                sb.append("import " + superClass + "\n\n");
            }
            sb.append("class ").append(typeName).append(" extends ").append(splits[splits.length - 1]);
        } else {
            sb.append("class ").append(typeName).append(" extends ").append(splits[splits.length - 1]);
        }
        sb.append(" {\n\n");
        sb.append("}");
        ICompilationUnit unit = pack.createCompilationUnit(String.valueOf(typeName) + DOT_GROOVY, sb.toString(), true, monitor);
        this.maybeCreatedType = unit.getType(typeName);
    }
}

