/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.wizards;

import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class NewClassWizardPage
extends org.eclipse.jdt.ui.wizards.NewClassWizardPage {
    private static final int FINAL_INDEX = 1;
    private IStatus fStatus;

    public NewClassWizardPage() {
        this.setTitle("Groovy Class");
        this.setDescription("Create a new Groovy class");
    }

    protected void createModifierControls(Composite composite, int nColumns) {
        super.createModifierControls(composite, nColumns);
        SelectionButtonDialogFieldGroup group = this.getOtherModifierButtonsFieldGroup();
        group.getSelectionButton(1).setText("Create Script");
    }

    protected String getCompilationUnitName(String typeName) {
        return String.valueOf(typeName) + ".groovy";
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        IMethod main;
        super.createTypeMembers(type, imports, monitor);
        if (this.isCreateMain() && (main = type.getMethod("main", new String[]{"[QString;"})) != null && main.exists()) {
            main.delete(true, monitor);
            type.createMethod("static main(args) {\n\n}", null, true, monitor);
        }
    }

    protected IStatus typeNameChanged() {
        StatusInfo status = (StatusInfo)super.typeNameChanged();
        IPackageFragment pack = this.getPackageFragment();
        if (pack == null) {
            return status;
        }
        IJavaProject project = pack.getJavaProject();
        try {
            if (!project.getProject().hasNature("org.eclipse.jdt.groovy.core.groovyNature")) {
                status.setWarning(String.valueOf(project.getElementName()) + " is not a groovy project.  Groovy Nature will be added to project upon completion.");
            }
        }
        catch (CoreException coreException) {
            status.setError("Exception when accessing project natures for " + project.getElementName());
        }
        String typeName = this.getTypeNameWithoutParameters();
        if (!this.isEnclosingTypeSelected() && status.getSeverity() < 4 && pack != null) {
            IType type = null;
            try {
                type = project.findType(pack.getElementName(), typeName);
            }
            catch (JavaModelException javaModelException) {}
            if (type != null && type.getPackageFragment().equals(pack)) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeNameExists);
            }
        }
        if (status.getSeverity() < 4) {
            try {
                ClasspathEntry entry = (ClasspathEntry)((IPackageFragmentRoot)pack.getParent()).getRawClasspathEntry();
                if (entry != null) {
                    char[][] inclusionPatterns = entry.fullInclusionPatternChars();
                    char[][] exclusionPatterns = entry.fullExclusionPatternChars();
                    if (Util.isExcluded((IPath)pack.getResource().getFullPath().append(this.getCompilationUnitName(typeName)), (char[][])inclusionPatterns, (char[][])exclusionPatterns, (boolean)false)) {
                        status.setError("Cannot create Groovy type because of exclusion patterns on the source folder.");
                    }
                }
            }
            catch (JavaModelException e) {
                status.setError(e.getLocalizedMessage());
                GroovyCore.logException((String)"Exception inside new Groovy class wizard", (Throwable)e);
            }
        }
        return status;
    }

    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        IProject project;
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null && !GroovyNature.hasGroovyNature((IProject)(project = pack.getJavaProject().getProject()))) {
            GroovyRuntime.addGroovyNature((IProject)project);
        }
        super.createType(monitor);
        monitor = new SubProgressMonitor(monitor, 1);
        GroovyCompilationUnit unit = (GroovyCompilationUnit)pack.getCompilationUnit(this.getCompilationUnitName(this.getTypeName()));
        try {
            ISourceRange range;
            int position;
            IImportDeclaration[] imports;
            ISourceRange range2;
            int position2;
            monitor.beginTask("Remove semi-colons", 1);
            unit.becomeWorkingCopy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IPackageDeclaration[] packs = unit.getPackageDeclarations();
            char[] contents = unit.getContents();
            MultiTextEdit multi = new MultiTextEdit();
            if (packs.length > 0 && contents[position2 = (range2 = packs[0].getSourceRange()).getOffset() + range2.getLength()] == ';') {
                multi.addChild((TextEdit)new ReplaceEdit(position2, 1, ""));
            }
            if ((imports = unit.getImports()) != null && imports.length > 0 && contents[position = (range = imports[0].getSourceRange()).getOffset() + range.getLength() - 1] == ';') {
                multi.addChild((TextEdit)new ReplaceEdit(position, 1, ""));
            }
            if (this.isScript()) {
                range = unit.getTypes()[0].getSourceRange();
                multi.addChild((TextEdit)new DeleteEdit(range.getOffset(), range.getLength()));
            }
            if (multi.hasChildren()) {
                unit.applyTextEdit((TextEdit)multi, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                unit.commitWorkingCopy(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            monitor.worked(1);
        }
        finally {
            if (unit != null) {
                unit.discardWorkingCopy();
            }
            monitor.done();
        }
    }

    private boolean isScript() {
        SelectionButtonDialogFieldGroup group = this.getOtherModifierButtonsFieldGroup();
        return group.isSelected(1);
    }

    public SelectionButtonDialogFieldGroup getOtherModifierButtonsFieldGroup() {
        return (SelectionButtonDialogFieldGroup)ReflectionUtils.getPrivateField(NewTypeWizardPage.class, (String)"fOtherMdfButtons", (Object)((Object)this));
    }

    private String getTypeNameWithoutParameters() {
        String typeNameWithParameters = this.getTypeName();
        int angleBracketOffset = typeNameWithParameters.indexOf(60);
        if (angleBracketOffset == -1) {
            return typeNameWithParameters;
        }
        return typeNameWithParameters.substring(0, angleBracketOffset);
    }

    public int getModifiers() {
        int modifiers = super.getModifiers();
        modifiers &= ~this.F_PUBLIC;
        modifiers &= ~this.F_PRIVATE;
        modifiers &= ~this.F_PROTECTED;
        return modifiers &= ~this.F_FINAL;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
        this.fStatus = status;
    }
}

