/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.wizards;

import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.eclipse.preferences.CompilerSwitchUIHelper;
import org.codehaus.groovy.frameworkadapter.util.SpecifiedVersion;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ListMessageDialog
extends MessageDialog {
    private static final String TITLE = "Fix compiler level mismatches";
    private final IProject[] mismatchedProjects;
    private IProject[] checkedMismatchedProjects;
    private CheckboxTableViewer viewer;

    public static IProject[] openViewer(Shell shell, IProject[] mismatchProjects) {
        ListMessageDialog dialog = new ListMessageDialog(shell, mismatchProjects);
        int res = dialog.open();
        if ((double)res == 0.0) {
            return dialog.getAllChecked();
        }
        return null;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            Object[] checkedElements = this.viewer.getCheckedElements();
            this.checkedMismatchedProjects = new IProject[checkedElements.length];
            System.arraycopy(checkedElements, 0, this.checkedMismatchedProjects, 0, checkedElements.length);
        }
        super.buttonPressed(buttonId);
    }

    protected boolean isResizable() {
        return true;
    }

    public ListMessageDialog(Shell shell, IProject[] mismatchedProjects) {
        super(shell, TITLE, null, ListMessageDialog.createMessage(mismatchedProjects), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        this.mismatchedProjects = mismatchedProjects;
    }

    protected Control createCustomArea(Composite parent) {
        ((GridLayout)parent.getLayout()).numColumns = 2;
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        gd.verticalSpan = 2;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider(){

            protected String decorateText(String input, Object element) {
                String label = super.decorateText(input, element);
                if (element instanceof IProject) {
                    SpecifiedVersion version = CompilerUtils.getCompilerLevel((IProject)((IProject)element));
                    return String.valueOf(label) + " -- " + version.toReadableVersionString();
                }
                return label;
            }
        });
        this.viewer.setInput((Object)this.mismatchedProjects);
        this.viewer.setAllChecked(true);
        ListMessageDialog.applyDialogFont((Control)this.viewer.getControl());
        this.createButton(parent, "Select all", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListMessageDialog.this.viewer.setAllChecked(true);
            }
        });
        this.createButton(parent, "Select none", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListMessageDialog.this.viewer.setAllChecked(false);
            }
        });
        Composite compilerBlock = CompilerSwitchUIHelper.createCompilerSwitchBlock(parent);
        compilerBlock.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        return parent;
    }

    protected Button createButton(Composite parent, String label, SelectionListener listener) {
        return this.createButton(parent, label, 8, listener);
    }

    protected Button createButton(Composite parent, String label, int style, SelectionListener listener) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        button.addSelectionListener(listener);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.verticalAlignment = 1;
        gd.widthHint = 100;
        button.setLayoutData((Object)gd);
        return button;
    }

    IProject[] getAllChecked() {
        return this.checkedMismatchedProjects;
    }

    private static String createMessage(IProject[] allMismatchedProjects) {
        StringBuilder sb = new StringBuilder();
        if (allMismatchedProjects.length > 1) {
            sb.append("The following Groovy compiler mismatches have been found.");
        } else {
            sb.append("The following Groovy compiler mismatch has been found.");
        }
        if (allMismatchedProjects.length > 1) {
            sb.append(" These projects may not compile until their compiler level matches the workspace level.\n\n");
        } else {
            sb.append(" This project may not compile until its compiler level matches the workspace level.\n\n");
        }
        sb.append("Do you want to change the project compiler levels to match the workspace level?");
        return sb.toString();
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IProject[]) {
                return (IProject[])inputElement;
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer2, Object oldInput, Object newInput) {
        }
    }
}

