/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.wizards;

import java.lang.reflect.InvocationTargetException;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.codehaus.groovy.eclipse.ui.decorators.GroovyPluginImages;
import org.codehaus.groovy.eclipse.wizards.NewWizardMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageTwo;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class GroovyProjectWizard
extends NewElementWizard
implements IExecutableExtension {
    protected NewJavaProjectWizardPageOne fFirstPage;
    protected NewJavaProjectWizardPageTwo fSecondPage;
    private IConfigurationElement fConfigElement;

    public GroovyProjectWizard() {
        this.setDefaultPageImageDescriptor(GroovyPluginImages.DESC_NEW_GROOVY_PROJECT);
        this.setDialogSettings(GroovyPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.GroovyProjectWizard_NewGroovyProject);
    }

    public void addPages() {
        super.addPages();
        this.fFirstPage = new NewJavaProjectWizardPageOne();
        this.addPage((IWizardPage)this.fFirstPage);
        this.fFirstPage.setTitle(NewWizardMessages.GroovyProjectWizard_CreateGroovyProject);
        this.fFirstPage.setDescription(NewWizardMessages.GroovyProjectWizard_CreateGroovyProjectDesc);
        this.fSecondPage = new NewJavaProjectWizardPageTwo(this.fFirstPage);
        this.fSecondPage.setTitle(NewWizardMessages.GroovyProjectWizard_BuildSettings);
        this.fSecondPage.setDescription(NewWizardMessages.GroovyProjectWizard_BuildSettingsDesc);
        this.addPage((IWizardPage)this.fSecondPage);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fSecondPage.performFinish(monitor);
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            boolean completed;
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            IProject project = this.fSecondPage.getJavaProject().getProject();
            this.selectAndReveal((IResource)project);
            IWorkingSet[] workingSets = this.fFirstPage.getWorkingSets();
            if (workingSets.length > 0) {
                PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)project, workingSets);
            }
            res = completed = this.finalizeNewProject(project);
        }
        return res;
    }

    protected void handleFinishException(Shell shell, InvocationTargetException e) {
        String title = NewWizardMessages.GroovyProjectWizard_OpErrorTitle;
        String message = NewWizardMessages.GroovyProjectWizard_OpErrorCreateMessage;
        ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
    }

    private boolean finalizeNewProject(IProject project) {
        IProject thisProject = project;
        try {
            GroovyRuntime.addGroovyRuntime((IProject)thisProject);
            thisProject.build(6, null);
        }
        catch (CoreException coreException) {}
        project = thisProject;
        this.selectAndReveal((IResource)project);
        GroovyCore.trace((String)("New project created: " + thisProject.getName()));
        return true;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public boolean performCancel() {
        this.fSecondPage.performCancel();
        return super.performCancel();
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    public IJavaElement getCreatedElement() {
        return this.fSecondPage.getJavaProject();
    }
}

