/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.ui.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.codehaus.groovy.eclipse.editor.actions.RenameToGroovyOrJavaAction;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyResourceUtil {
    public static final String GROOVY = ".groovy";
    public static final String JAVA = ".java";

    private GroovyResourceUtil() {
    }

    public static IStatus renameFile(String type, List<IResource> resources) {
        RenameToGroovyOrJavaJob renameTo = new RenameToGroovyOrJavaJob(type, resources);
        renameTo.schedule();
        return Status.OK_STATUS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RenameToGroovyOrJavaJob
    extends UIJob {
        private List<IResource> resources;
        private String javaOrGroovy;

        private RenameToGroovyOrJavaJob(String javaOrGroovy, List<IResource> resources) {
            super(RenameToGroovyOrJavaJob.getJobName(javaOrGroovy));
            this.resources = resources;
            this.javaOrGroovy = javaOrGroovy;
        }

        protected static String getJobName(String javaOrGroovy) {
            return "Rename to " + javaOrGroovy;
        }

        public boolean belongsTo(Object family) {
            return RenameToGroovyOrJavaAction.class == family;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            HashSet<IProject> affectedProjects = new HashSet<IProject>();
            HashSet<IResource> filesAlreadyOpened = new HashSet<IResource>();
            for (IResource resource : this.resources) {
                if (resource == null || resource.getType() != 1) continue;
                IDE.saveAllEditors((IResource[])new IFile[]{(IFile)resource}, (boolean)true);
                String name = this.convertName(resource);
                RenameResourceChange change = new RenameResourceChange(resource.getFullPath(), name);
                try {
                    if (this.isOpenInEditor(resource)) {
                        filesAlreadyOpened.add(resource);
                    }
                    change.perform(monitor);
                    IProject project = resource.getProject();
                    if (GroovyNature.hasGroovyNature((IProject)project)) continue;
                    affectedProjects.add(project);
                }
                catch (CoreException e) {
                    String message = "Error converting file extension to " + this.javaOrGroovy + " for file " + resource.getName();
                    GroovyCore.logException((String)message, (Throwable)e);
                    return new Status(4, "org.codehaus.groovy.eclipse.ui", message, (Throwable)e);
                }
            }
            if (!affectedProjects.isEmpty() && this.javaOrGroovy.equals(GroovyResourceUtil.GROOVY)) {
                this.askToConvert(affectedProjects, this.getDisplay().getActiveShell());
            }
            this.reopenFiles(filesAlreadyOpened);
            return Status.OK_STATUS;
        }

        protected String convertName(IResource file) {
            String name = file.getName();
            name = name.substring(0, name.lastIndexOf(46));
            name = String.valueOf(name) + this.javaOrGroovy;
            return name;
        }

        protected void reopenFiles(Set<IResource> filesAlreadyOpened) {
            for (IResource origResource : filesAlreadyOpened) {
                String name = this.convertName(origResource);
                IFile newFile = origResource.getParent().getFile((IPath)new Path(name));
                try {
                    IDE.openEditor((IWorkbenchPage)this.getWorkbenchPage(), (IFile)newFile);
                }
                catch (PartInitException e) {
                    GroovyCore.logException((String)("Exception thrown when opening " + name + " in an editor"), (Throwable)e);
                }
            }
        }

        private IWorkbenchPage getWorkbenchPage() {
            return PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage();
        }

        protected void askToConvert(Set<IProject> affectedProjects, Shell shell) {
            if (affectedProjects.size() == 0) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            if (affectedProjects.size() > 1) {
                sb.append("Projects ");
                for (IProject project : affectedProjects) {
                    sb.append(project.getName()).append(", ");
                }
                sb.replace(sb.length() - 2, 2, " do ");
            } else {
                sb.append("Project ").append(affectedProjects.iterator().next().getName()).append(" does ");
            }
            sb.append("have the Groovy nature.  Do you want to add it?");
            boolean yes = MessageDialog.openQuestion((Shell)shell, (String)"Convert to Groovy?", (String)sb.toString());
            if (yes) {
                for (IProject project : affectedProjects) {
                    GroovyRuntime.addGroovyRuntime((IProject)project);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean isOpenInEditor(IResource file) {
            try {
                IEditorReference[] refs;
                IEditorReference[] iEditorReferenceArray = refs = this.getWorkbenchPage().getEditorReferences();
                int n = refs.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    IEditorReference ref = iEditorReferenceArray[n2];
                    try {
                        IFileEditorInput input;
                        if (ref.getEditorInput() instanceof IFileEditorInput && (input = (IFileEditorInput)ref.getEditorInput()).getFile().equals((Object)file)) {
                            return true;
                        }
                    }
                    catch (PartInitException partInitException) {}
                    ++n2;
                }
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            return false;
        }
    }
}

