/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.ui.decorators;

import org.codehaus.groovy.eclipse.ui.decorators.GroovyPluginImages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;
import org.eclipse.jdt.groovy.core.util.ScriptFolderSelector;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.viewsupport.TreeHierarchyLayoutProblemsDecorator;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecoratorManager;

public class GroovyImageDecorator
implements ILabelDecorator {
    private ImageDescriptorRegistry fRegistry;
    private TreeHierarchyLayoutProblemsDecorator problemsDecorator = new TreeHierarchyLayoutProblemsDecorator();
    private DecoratorManager decman = WorkbenchPlugin.getDefault().getDecoratorManager();
    private boolean preventRecursion = false;
    private PreferenceChangeListener listener = new PreferenceChangeListener();
    private static final String GROOVY_NATURE = "org.eclipse.jdt.groovy.core.groovyNature";
    private ScriptFolderSelector scriptFolderSelector;

    public GroovyImageDecorator() {
        new InstanceScope().getNode("org.eclipse.jdt.groovy.core").addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.listener);
        this.scriptFolderSelector = new ScriptFolderSelector(null);
    }

    public Image decorateImage(Image image, Object element) {
        if (this.preventRecursion) {
            return null;
        }
        if (element instanceof String) {
            image = this.getImageLabel((ImageDescriptor)new JavaElementImageDescriptor(GroovyPluginImages.DESC_GROOVY_FILE, 0, JavaElementImageProvider.SMALL_SIZE));
        } else {
            IResource resource = null;
            if (element instanceof IResource) {
                resource = (IResource)element;
            } else if (element instanceof ICompilationUnit) {
                resource = ((ICompilationUnit)element).getResource();
            }
            if (resource != null && ContentTypeUtils.isGroovyLikeFileName((String)resource.getName())) {
                image = this.getJavaElementImageDescriptor(image, resource);
            }
        }
        if (image != null) {
            this.preventRecursion = true;
            try {
                image = this.problemsDecorator.decorateImage(image, element);
                image = this.decman.decorateImage(image, element);
            }
            finally {
                this.preventRecursion = false;
            }
            return image;
        }
        return null;
    }

    private Image getJavaElementImageDescriptor(Image image, IResource resource) {
        ImageDescriptor desc;
        int flags;
        if (image != null) {
            Rectangle rect = image.getBounds();
            flags = rect.width == 16 ? 2 : 0;
        } else {
            flags = 2;
        }
        Point size = GroovyImageDecorator.useSmallSize(flags) ? JavaElementImageProvider.SMALL_SIZE : JavaElementImageProvider.BIG_SIZE;
        try {
            desc = resource.getProject().hasNature(GROOVY_NATURE) ? (this.scriptFolderSelector.isScript(resource.getProjectRelativePath().toPortableString().toCharArray()) ? GroovyPluginImages.DESC_GROOVY_FILE_SCRIPT : GroovyPluginImages.DESC_GROOVY_FILE) : GroovyPluginImages.DESC_GROOVY_FILE_NO_BUILD;
        }
        catch (CoreException coreException) {
            desc = GroovyPluginImages.DESC_GROOVY_FILE_NO_BUILD;
        }
        return this.getImageLabel((ImageDescriptor)new JavaElementImageDescriptor(desc, 0, size));
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    private Image getImageLabel(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return this.getRegistry().get(descriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    class PreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        PreferenceChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            GroovyImageDecorator.this.scriptFolderSelector = new ScriptFolderSelector(null);
        }
    }
}

