/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.ui.cpcontainer;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.builder.GroovyClasspathContainer;
import org.codehaus.groovy.eclipse.core.builder.GroovyClasspathContainerInitializer;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.prefs.BackingStoreException;

public class GroovyClasspathContainerPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IJavaProject jProject;
    private IEclipsePreferences prefStore;
    private IClasspathEntry containerEntryResult;
    private Button[] useGroovyLib;
    private Button yesButt;
    private Button noButt;

    public GroovyClasspathContainerPage() {
        super("Groovy Classpath Container");
        this.setTitle("Groovy Libraries");
        this.setDescription("Configure the Groovy Library classpath container");
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
    }

    private UseGroovyLib getPreference() {
        return this.prefStore != null ? UseGroovyLib.fromString(this.prefStore.get("groovy.classpath.use.groovy,lib", "default")) : UseGroovyLib.DEFAULT;
    }

    public boolean finish() {
        try {
            UseGroovyLib currentPreference;
            UseGroovyLib storedPreference;
            if (this.prefStore != null && (storedPreference = this.getPreference()) != (currentPreference = this.getPreferenceSelection())) {
                this.prefStore.put("groovy.classpath.use.groovy,lib", currentPreference.val());
                this.prefStore.flush();
            }
            GroovyRuntime.ensureGroovyClasspathContainer((IJavaProject)this.jProject, (boolean)this.noButt.getSelection());
            this.refreshNow();
        }
        catch (BackingStoreException e) {
            GroovyCore.logException((String)"Exception trying to store Groovy classpath container changes", (Throwable)e);
        }
        return true;
    }

    private UseGroovyLib getPreferenceSelection() {
        if (this.useGroovyLib[0].getSelection()) {
            return (UseGroovyLib)((Object)this.useGroovyLib[0].getData());
        }
        if (this.useGroovyLib[1].getSelection()) {
            return (UseGroovyLib)((Object)this.useGroovyLib[1].getData());
        }
        if (this.useGroovyLib[2].getSelection()) {
            return (UseGroovyLib)((Object)this.useGroovyLib[2].getData());
        }
        return UseGroovyLib.DEFAULT;
    }

    private void refreshNow() {
        try {
            if (this.jProject != null) {
                GroovyClasspathContainerInitializer.updateGroovyClasspathContainer((IJavaProject)this.jProject);
            }
        }
        catch (JavaModelException e) {
            GroovyCore.logException((String)"Exception trying to store Groovy classpath container changes", (Throwable)e);
        }
    }

    public IClasspathEntry getSelection() {
        return this.containerEntryResult != null ? this.containerEntryResult : JavaCore.newContainerEntry((IPath)GroovyClasspathContainer.CONTAINER_ID);
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.containerEntryResult = containerEntry;
    }

    private boolean hasAttribute() {
        try {
            return GroovyClasspathContainer.hasMinimalAttribute((IClasspathEntry)this.containerEntryResult);
        }
        catch (JavaModelException e) {
            GroovyCore.logException((String)"Error getting Groovy Classpath container", (Throwable)e);
            return false;
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite isMinimalContainer = new Composite(composite, 2048);
        isMinimalContainer.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        isMinimalContainer.setLayout((Layout)new GridLayout(1, false));
        Label isMinimal = new Label(isMinimalContainer, 64);
        isMinimal.setText("Should all jars in the groovy-eclipse lib folder be included on the classpath?");
        boolean hasAttribute = this.hasAttribute();
        this.yesButt = new Button(isMinimalContainer, 16);
        this.yesButt.setText("Yes, include groovy-all and " + this.extraJarsAsString());
        this.yesButt.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.yesButt.setSelection(!hasAttribute);
        this.noButt = new Button(isMinimalContainer, 16);
        this.noButt.setText("No, only include groovy-all");
        this.noButt.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.noButt.setSelection(hasAttribute);
        Composite dotGroovyContainer = new Composite(composite, 2048);
        dotGroovyContainer.setLayout((Layout)new GridLayout(1, false));
        dotGroovyContainer.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        Label should = new Label(dotGroovyContainer, 64);
        should.setText("Should jars in the ~/.groovy/lib directory be included on the classpath?");
        this.useGroovyLib = new Button[3];
        int i = 0;
        while (i < this.useGroovyLib.length) {
            this.useGroovyLib[i] = new Button(dotGroovyContainer, 16);
            this.useGroovyLib[i].setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            this.useGroovyLib[i].setSelection(this.getPreference() == UseGroovyLib.values()[i]);
            this.useGroovyLib[i].setData((Object)UseGroovyLib.values()[i]);
            this.useGroovyLib[i].setText(UseGroovyLib.values()[i].label());
            if (this.prefStore == null) {
                this.useGroovyLib[i].setEnabled(false);
            }
            ++i;
        }
        Label l = new Label(dotGroovyContainer, 0);
        l.setText("(Affects this project only)");
        l = new Label(composite, 0);
        l.setText("Groovy Libraries will automatically be refreshed for this project when 'Finish' is clicked.");
        this.setControl((Control)composite);
    }

    private String extraJarsAsString() {
        URL[] extraJars = CompilerUtils.getExtraJarsForClasspath();
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        URL[] uRLArray = extraJars;
        int n = extraJars.length;
        int n2 = 0;
        while (n2 < n) {
            URL jar = uRLArray[n2];
            try {
                sb.append(new File(jar.toURI()).getName()).append("\n");
            }
            catch (URISyntaxException uRISyntaxException) {}
            ++n2;
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        return sb.toString();
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        if (project == null) {
            return;
        }
        this.jProject = project;
        this.prefStore = this.preferenceStore(this.jProject.getProject());
    }

    private IEclipsePreferences preferenceStore(IProject p) {
        ProjectScope projectScope = new ProjectScope(p);
        return projectScope.getNode("org.codehaus.groovy.eclipse.core");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UseGroovyLib {
        TRUE("true", "Yes"),
        FALSE("false", "No"),
        DEFAULT("default", "Use workspace default");

        private final String val;
        private final String label;

        private UseGroovyLib(String val, String label) {
            this.val = val;
            this.label = label;
        }

        String val() {
            return this.val;
        }

        String label() {
            return this.label;
        }

        static UseGroovyLib fromString(String val) {
            if (val.equals(UseGroovyLib.TRUE.val)) {
                return TRUE;
            }
            if (val.equals(UseGroovyLib.FALSE.val)) {
                return FALSE;
            }
            return DEFAULT;
        }
    }
}

