/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.ui.console;

import java.util.ArrayList;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.ui.console.GroovyConsolePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.IPageBookViewPage;

public class GroovyConsole
extends TextConsole {
    public static final String CONSOLE_TYPE = "GroovyEventTraceConsole";
    static final RuleBasedPartitionScanner scanner = new RuleBasedPartitionScanner();
    private GroovyEventTraceConsolePartitioner partitioner;
    private IPropertyChangeListener propertyListener;

    public GroovyConsole(String name, String consoleType, ImageDescriptor imageDescriptor, boolean autoLifecycle) {
        super(name, consoleType, imageDescriptor, autoLifecycle);
        ArrayList<SingleLineRule> rules = new ArrayList<SingleLineRule>(TraceCategory.values().length);
        TraceCategory[] traceCategoryArray = TraceCategory.values();
        int n = traceCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            TraceCategory category = traceCategoryArray[n2];
            rules.add(new SingleLineRule(category.getPaddedLabel(), "", (IToken)new Token((Object)category.label)));
            ++n2;
        }
        scanner.setPredicateRules(rules.toArray(new IPredicateRule[0]));
        this.partitioner = new GroovyEventTraceConsolePartitioner();
        this.propertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals("org.eclipse.debug.ui.consoleFont")) {
                    GroovyConsole.this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
                }
            }
        };
    }

    public GroovyConsole() {
        super("Groovy Event Trace Console", CONSOLE_TYPE, null, true);
        ArrayList<SingleLineRule> rules = new ArrayList<SingleLineRule>(TraceCategory.values().length);
        TraceCategory[] traceCategoryArray = TraceCategory.values();
        int n = traceCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            TraceCategory category = traceCategoryArray[n2];
            rules.add(new SingleLineRule(category.getPaddedLabel(), "", (IToken)new Token((Object)category.label)));
            ++n2;
        }
        scanner.setPredicateRules(rules.toArray(new IPredicateRule[0]));
        this.partitioner = new GroovyEventTraceConsolePartitioner();
        this.propertyListener = new /* invalid duplicate definition of identical inner class */;
        Font font = JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont");
        this.setFont(font);
        this.partitioner.connect(this.getDocument());
    }

    protected void init() {
        JFaceResources.getFontRegistry().addListener(this.propertyListener);
    }

    protected void dispose() {
        JFaceResources.getFontRegistry().removeListener(this.propertyListener);
        super.dispose();
    }

    protected IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        return new GroovyConsolePage(this, view);
    }

    class GroovyEventTraceConsolePartitioner
    extends FastPartitioner
    implements IConsoleDocumentPartitioner {
        public GroovyEventTraceConsolePartitioner() {
            super((IPartitionTokenScanner)scanner, TraceCategory.stringValues());
            GroovyConsole.this.getDocument().setDocumentPartitioner((IDocumentPartitioner)this);
        }

        public boolean isReadOnly(int offset) {
            return true;
        }

        public StyleRange[] getStyleRanges(int offset, int length) {
            ITypedRegion[] regions = this.computePartitioning(offset, length);
            StyleRange[] styles = new StyleRange[regions.length];
            int i = 0;
            while (i < regions.length) {
                styles[i] = TraceCategory.CLASSPATH.label.equals(regions[i].getType()) ? new StyleRange(offset, length, Display.getDefault().getSystemColor(6), null) : (TraceCategory.COMPILER.label.equals(regions[i].getType()) ? new StyleRange(offset, length, Display.getDefault().getSystemColor(9), null) : (TraceCategory.DSL.label.equals(regions[i].getType()) ? new StyleRange(offset, length, Display.getDefault().getSystemColor(4), null) : (TraceCategory.REFACTORING.label.equals(regions[i].getType()) ? new StyleRange(offset, length, Display.getDefault().getSystemColor(8), null) : new StyleRange(offset, length, null, null))));
                ++i;
            }
            return styles;
        }
    }
}

